/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.RedstonePowerFramework;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicWood;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsWood
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    protected int baseTexture = 16;
    protected int plainTexture = 31;

    protected PipeItemsWood(PipeTransportItems transport, PipeLogic logic, int itemID) {
        super(transport, logic, itemID);
        this.powerProvider.configure(50, 1, 64, 1, 64);
        this.powerProvider.configurePowerPerdition(64, 1);
    }

    protected PipeItemsWood(int itemID, PipeTransportItems transport) {
        this(transport, (PipeLogic)new PipeLogicWood(), itemID);
    }

    public PipeItemsWood(int itemID) {
        this(itemID, new PipeTransportItems());
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.baseTexture;
        }
        int metadata = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.plainTexture;
        }
        return this.baseTexture;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        yc w2 = this.worldObj;
        int meta = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, ForgeDirection.getOrientation((int)meta));
        pos.moveForwards(1.0);
        any tile = w2.q((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof la) {
            if (!PipeManager.canExtractItems(this, w2, (int)pos.x, (int)pos.y, (int)pos.z)) {
                return;
            }
            la inventory = (la)tile;
            ur[] extracted = this.checkExtract(inventory, true, pos.orientation.getOpposite());
            if (extracted == null) {
                return;
            }
            for (ur stack : extracted) {
                if (stack == null || stack.a == 0) {
                    this.powerProvider.useEnergy(1.0f, 1.0f, false);
                    continue;
                }
                Position entityPos = new Position(pos.x + 0.5, pos.y + 0.5, pos.z + 0.5, pos.orientation.getOpposite());
                entityPos.moveForwards(0.6);
                EntityPassiveItem entity = new EntityPassiveItem(w2, entityPos.x, entityPos.y, entityPos.z, stack);
                ((PipeTransportItems)this.transport).entityEntering(entity, entityPos.orientation);
            }
        }
    }

    public ur[] checkExtract(la inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISpecialInventory) {
            ur[] stacks = ((ISpecialInventory)inventory).extractItem(doRemove, from, (int)this.powerProvider.getEnergyStored());
            if (stacks != null && doRemove) {
                for (ur stack : stacks) {
                    if (stack == null) continue;
                    this.powerProvider.useEnergy(stack.a, stack.a, true);
                }
            }
            return stacks;
        }
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int first = sidedInv.getStartInventorySide(from);
            int last = first + sidedInv.getSizeInventorySide(from) - 1;
            la inv = Utils.getInventory(inventory);
            ur result = this.checkExtractGeneric(inv, doRemove, from, first, last);
            if (result != null) {
                return new ur[]{result};
            }
        } else if (inventory.k_() == 2) {
            int slotIndex = 0;
            slotIndex = from == ForgeDirection.DOWN || from == ForgeDirection.UP ? 0 : 1;
            ur slot = inventory.a(slotIndex);
            if (slot != null && slot.a > 0) {
                if (doRemove) {
                    return new ur[]{inventory.a(slotIndex, (int)this.powerProvider.useEnergy(1.0f, slot.a, true))};
                }
                return new ur[]{slot};
            }
        } else if (inventory.k_() == 3) {
            int slotIndex = 0;
            slotIndex = from == ForgeDirection.UP ? 0 : (from == ForgeDirection.DOWN ? 1 : 2);
            ur slot = inventory.a(slotIndex);
            if (slot != null && slot.a > 0) {
                if (doRemove) {
                    return new ur[]{inventory.a(slotIndex, (int)this.powerProvider.useEnergy(1.0f, slot.a, true))};
                }
                return new ur[]{slot};
            }
        } else {
            la inv = Utils.getInventory(inventory);
            ur result = this.checkExtractGeneric(inv, doRemove, from, 0, inv.k_() - 1);
            if (result != null) {
                return new ur[]{result};
            }
        }
        return null;
    }

    public ur checkExtractGeneric(la inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int k = start; k <= stop; ++k) {
            ur slot = inventory.a(k);
            if (slot == null || slot.a <= 0) continue;
            if (doRemove) {
                return inventory.a(k, (int)this.powerProvider.useEnergy(1.0f, slot.a, true));
            }
            return slot;
        }
        return null;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public boolean canConnectRedstone() {
        if (PowerFramework.currentFramework instanceof RedstonePowerFramework) {
            return true;
        }
        return super.canConnectRedstone();
    }
}

