/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLiquidsWood;
import buildcraft.transport.pipes.PipeLogic;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;

public class PipeLogicWood
extends PipeLogic {
    public void switchSource() {
        int meta = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        int newMeta = 6;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection o = ForgeDirection.values()[i % 6];
            any tile = this.container.getTile(o);
            if (!this.isInput(tile) || !PipeManager.canExtractItems(this.container.getPipe(), tile.k, tile.l, tile.m, tile.n) && !PipeManager.canExtractLiquids(this.container.getPipe(), tile.k, tile.l, tile.m, tile.n)) continue;
            newMeta = o.ordinal();
            break;
        }
        if (newMeta != meta) {
            this.worldObj.d(this.xCoord, this.yCoord, this.zCoord, newMeta);
            this.container.scheduleRenderUpdate();
        }
    }

    public boolean isInput(any tile) {
        return !(tile instanceof TileGenericPipe) && (tile instanceof la || tile instanceof ITankContainer) && Utils.checkPipesConnections(this.container, tile);
    }

    @Override
    public boolean blockActivated(qx entityplayer) {
        up equipped;
        up up2 = equipped = entityplayer.bS() != null ? entityplayer.bS().b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.xCoord, this.yCoord, this.zCoord)) {
            this.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPipeConnected(any tile) {
        Pipe pipe2 = null;
        if (tile instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)tile).pipe;
        }
        if (BuildCraftTransport.alwaysConnectPipes) {
            return super.isPipeConnected(tile);
        }
        return (pipe2 == null || !(pipe2.logic instanceof PipeLogicWood)) && super.isPipeConnected(tile);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            this.switchSourceIfNeeded();
        }
    }

    private void switchSourceIfNeeded() {
        int meta = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            this.switchSource();
        } else {
            any tile = this.container.getTile(ForgeDirection.values()[meta]);
            if (!this.isInput(tile)) {
                this.switchSource();
            }
        }
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            this.switchSourceIfNeeded();
        }
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        if (this.container.pipe instanceof PipeLiquidsWood) {
            int meta = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
            return meta != to.ordinal();
        }
        return super.outputOpen(to);
    }
}

