/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.transport.IPipe;
import buildcraft.core.DefaultProps;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TransportProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeDirection;

public class PipeWorldRenderer
implements ISimpleBlockRenderingHandler {
    public static final float facadeThickness = 0.0625f;

    private void mirrorY(float[][] targetArray) {
        float temp = targetArray[1][0];
        targetArray[1][0] = (targetArray[1][1] - 0.5f) * -1.0f + 0.5f;
        targetArray[1][1] = (temp - 0.5f) * -1.0f + 0.5f;
    }

    private void rotate(float[][] targetArray) {
        for (int i = 0; i < 2; ++i) {
            float temp = targetArray[2][i];
            targetArray[2][i] = targetArray[1][i];
            targetArray[1][i] = targetArray[0][i];
            targetArray[0][i] = temp;
        }
    }

    private void transform(float[][] targetArray, ForgeDirection direction) {
        if ((direction.ordinal() & 1) == 1) {
            this.mirrorY(targetArray);
        }
        for (int i = 0; i < direction.ordinal() >> 1; ++i) {
            this.rotate(targetArray);
        }
    }

    private float[][] deepClone(float[][] source) {
        float[][] target = (float[][])source.clone();
        for (int i = 0; i < target.length; ++i) {
            target[i] = (float[])source[i].clone();
        }
        return target;
    }

    public void renderPipe(bbb renderblocks, ym iblockaccess, amq block, PipeRenderState state, int x, int y2, int z) {
        float minSize = 0.25f;
        float maxSize = 0.75f;
        ForgeHooksClient.bindTexture((String)state.getTextureFile(), (int)0);
        state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN);
        block.a(minSize, minSize, minSize, maxSize, maxSize, maxSize);
        renderblocks.a(block);
        renderblocks.q(block, x, y2, z);
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.WEST)) {
            state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.WEST);
            block.a(0.0f, minSize, minSize, minSize, maxSize, maxSize);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.EAST)) {
            state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.EAST);
            block.a(maxSize, minSize, minSize, 1.0f, maxSize, maxSize);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.DOWN)) {
            state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.DOWN);
            block.a(minSize, 0.0f, minSize, maxSize, minSize, maxSize);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.UP)) {
            state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.UP);
            block.a(minSize, maxSize, minSize, maxSize, 1.0f, maxSize);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.NORTH)) {
            state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.NORTH);
            block.a(minSize, minSize, 0.0f, maxSize, maxSize, minSize);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.SOUTH)) {
            state.currentTextureIndex = state.textureMatrix.getTextureIndex(ForgeDirection.SOUTH);
            block.a(minSize, minSize, maxSize, maxSize, maxSize, 1.0f);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ForgeHooksClient.bindTexture((String)DefaultProps.TEXTURE_BLOCKS, (int)0);
        if (state.wireMatrix.hasWire(IPipe.WireColor.Red)) {
            state.currentTextureIndex = state.wireMatrix.getTextureIndex(IPipe.WireColor.Red);
            this.pipeWireRender(renderblocks, block, state, 0.25f, 0.75f, 0.25f, IPipe.WireColor.Red, x, y2, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Blue)) {
            state.currentTextureIndex = state.wireMatrix.getTextureIndex(IPipe.WireColor.Blue);
            this.pipeWireRender(renderblocks, block, state, 0.75f, 0.75f, 0.75f, IPipe.WireColor.Blue, x, y2, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Green)) {
            state.currentTextureIndex = state.wireMatrix.getTextureIndex(IPipe.WireColor.Green);
            this.pipeWireRender(renderblocks, block, state, 0.75f, 0.25f, 0.25f, IPipe.WireColor.Green, x, y2, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Yellow)) {
            state.currentTextureIndex = state.wireMatrix.getTextureIndex(IPipe.WireColor.Yellow);
            this.pipeWireRender(renderblocks, block, state, 0.25f, 0.25f, 0.75f, IPipe.WireColor.Yellow, x, y2, z);
        }
        if (state.hasGate()) {
            this.pipeGateRender(renderblocks, block, state, x, y2, z);
        }
        this.pipeFacadeRenderer(renderblocks, block, state, x, y2, z);
    }

    private void pipeFacadeRenderer(bbb renderblocks, amq block, PipeRenderState state, int x, int y2, int z) {
        float[][] rotated;
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.0f - zFightOffset / 2.0f;
        zeroState[0][1] = 1.0f + zFightOffset / 2.0f;
        zeroState[1][0] = 0.0f - zFightOffset;
        zeroState[1][1] = 0.0625f;
        zeroState[2][0] = 0.0f;
        zeroState[2][1] = 1.0f;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.facadeMatrix.isConnected(direction)) continue;
            ForgeHooksClient.bindTexture((String)state.facadeMatrix.getTextureFile(direction), (int)0);
            state.currentTextureIndex = state.facadeMatrix.getTextureIndex(direction);
            if (state.pipeConnectionMatrix.isConnected(direction)) {
                rotated = this.deepClone(zeroState);
                rotated[2][0] = 0.0f;
                rotated[2][1] = 0.25f;
                float[] fArray = rotated[1];
                fArray[0] = fArray[0] - zFightOffset / 2.0f;
                this.transform(rotated, direction);
                block.a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                renderblocks.a(block);
                renderblocks.q(block, x, y2, z);
                rotated = this.deepClone(zeroState);
                rotated[2][0] = 0.75f;
                float[] fArray2 = rotated[1];
                fArray2[0] = fArray2[0] - zFightOffset / 2.0f;
                this.transform(rotated, direction);
                block.a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                renderblocks.a(block);
                renderblocks.q(block, x, y2, z);
                rotated = this.deepClone(zeroState);
                rotated[0][0] = 0.0f;
                rotated[0][1] = 0.25f;
                float[] fArray3 = rotated[1];
                fArray3[1] = fArray3[1] - zFightOffset;
                this.transform(rotated, direction);
                block.a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                renderblocks.a(block);
                renderblocks.q(block, x, y2, z);
                rotated = this.deepClone(zeroState);
                rotated[0][0] = 0.75f;
                rotated[0][1] = 1.0f;
                float[] fArray4 = rotated[1];
                fArray4[1] = fArray4[1] - zFightOffset;
                this.transform(rotated, direction);
                block.a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                renderblocks.a(block);
                renderblocks.q(block, x, y2, z);
                continue;
            }
            rotated = this.deepClone(zeroState);
            this.transform(rotated, direction);
            block.a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        zeroState[0][0] = 0.25f;
        zeroState[0][1] = 0.75f;
        zeroState[1][0] = 0.0625f;
        zeroState[1][1] = 0.25f;
        zeroState[2][0] = 0.25f;
        zeroState[2][1] = 0.75f;
        ForgeHooksClient.bindTexture((String)DefaultProps.TEXTURE_BLOCKS, (int)0);
        state.currentTextureIndex = 125;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.facadeMatrix.isConnected(direction) || state.pipeConnectionMatrix.isConnected(direction)) continue;
            rotated = this.deepClone(zeroState);
            this.transform(rotated, direction);
            block.a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
    }

    private void pipeWireRender(bbb renderblocks, amq block, PipeRenderState state, float cx, float cy, float cz, IPipe.WireColor color, int x, int y2, int z) {
        boolean found;
        float minX = 0.25f;
        float minY = 0.25f;
        float minZ = 0.25f;
        float maxX = 0.75f;
        float maxY = 0.75f;
        float maxZ = 0.75f;
        boolean foundX = false;
        boolean foundY = false;
        boolean foundZ = false;
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.WEST)) {
            minX = 0.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.EAST)) {
            maxX = 1.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.DOWN)) {
            minY = 0.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.UP)) {
            maxY = 1.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.NORTH)) {
            minZ = 0.0f;
            foundZ = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.SOUTH)) {
            maxZ = 1.0f;
            foundZ = true;
        }
        boolean center = false;
        if (minX == 0.0f && maxX != 1.0f && (foundY || foundZ)) {
            if (cx == 0.25f) {
                maxX = 0.25f;
            } else {
                center = true;
            }
        }
        if (minX != 0.0f && maxX == 1.0f && (foundY || foundZ)) {
            if (cx == 0.75f) {
                minX = 0.75f;
            } else {
                center = true;
            }
        }
        if (minY == 0.0f && maxY != 1.0f && (foundX || foundZ)) {
            if (cy == 0.25f) {
                maxY = 0.25f;
            } else {
                center = true;
            }
        }
        if (minY != 0.0f && maxY == 1.0f && (foundX || foundZ)) {
            if (cy == 0.75f) {
                minY = 0.75f;
            } else {
                center = true;
            }
        }
        if (minZ == 0.0f && maxZ != 1.0f && (foundX || foundY)) {
            if (cz == 0.25f) {
                maxZ = 0.25f;
            } else {
                center = true;
            }
        }
        if (minZ != 0.0f && maxZ == 1.0f && (foundX || foundY)) {
            if (cz == 0.75f) {
                minZ = 0.75f;
            } else {
                center = true;
            }
        }
        boolean bl = found = foundX || foundY || foundZ;
        if (minZ != 0.25f || maxZ != 0.75f || !found) {
            block.a(cx == 0.25f ? cx - 0.05f : cx, cy == 0.25f ? cy - 0.05f : cy, minZ, cx == 0.25f ? cx : cx + 0.05f, cy == 0.25f ? cy : cy + 0.05f, maxZ);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (minX != 0.25f || maxX != 0.75f || !found) {
            block.a(minX, cy == 0.25f ? cy - 0.05f : cy, cz == 0.25f ? cz - 0.05f : cz, maxX, cy == 0.25f ? cy : cy + 0.05f, cz == 0.25f ? cz : cz + 0.05f);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (minY != 0.25f || maxY != 0.75f || !found) {
            block.a(cx == 0.25f ? cx - 0.05f : cx, minY, cz == 0.25f ? cz - 0.05f : cz, cx == 0.25f ? cx : cx + 0.05f, maxY, cz == 0.25f ? cz : cz + 0.05f);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (center || !found) {
            block.a(cx == 0.25f ? cx - 0.05f : cx, cy == 0.25f ? cy - 0.05f : cy, cz == 0.25f ? cz - 0.05f : cz, cx == 0.25f ? cx : cx + 0.05f, cy == 0.25f ? cy : cy + 0.05f, cz == 0.25f ? cz : cz + 0.05f);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
    }

    private void pipeGateRender(bbb renderblocks, amq block, PipeRenderState state, int x, int y2, int z) {
        state.currentTextureIndex = state.getGateTextureIndex();
        float min = 0.3f;
        float max = 0.7f;
        if (!state.pipeConnectionMatrix.isConnected(ForgeDirection.WEST) && !state.facadeMatrix.isConnected(ForgeDirection.WEST)) {
            block.a(0.15f, min, min, 0.25f, max, max);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (!state.pipeConnectionMatrix.isConnected(ForgeDirection.EAST) && !state.facadeMatrix.isConnected(ForgeDirection.EAST)) {
            block.a(0.75f, min, min, 0.85f, max, max);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (!state.pipeConnectionMatrix.isConnected(ForgeDirection.DOWN) && !state.facadeMatrix.isConnected(ForgeDirection.DOWN)) {
            block.a(min, 0.15f, min, max, 0.25f, max);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (!state.pipeConnectionMatrix.isConnected(ForgeDirection.UP) && !state.facadeMatrix.isConnected(ForgeDirection.UP)) {
            block.a(min, 0.75f, min, max, 0.85f, max);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (!state.pipeConnectionMatrix.isConnected(ForgeDirection.NORTH) && !state.facadeMatrix.isConnected(ForgeDirection.NORTH)) {
            block.a(min, min, 0.15f, max, max, 0.25f);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
        if (!state.pipeConnectionMatrix.isConnected(ForgeDirection.SOUTH) && !state.facadeMatrix.isConnected(ForgeDirection.SOUTH)) {
            block.a(min, min, 0.75f, max, max, 0.85f);
            renderblocks.a(block);
            renderblocks.q(block, x, y2, z);
        }
    }

    public void renderInventoryBlock(amq block, int metadata, int modelID, bbb renderer) {
    }

    public boolean renderWorldBlock(ym world, int x, int y2, int z, amq block, int modelId, bbb renderer) {
        any tile = world.q(x, y2, z);
        if (tile instanceof IPipeRenderState) {
            IPipeRenderState pipeTile = (IPipeRenderState)tile;
            this.renderPipe(renderer, world, block, pipeTile.getRenderState(), x, y2, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return TransportProxy.pipeModel;
    }
}

