/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftCore;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.transport.EntityData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderPipe
extends bdx {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private final px dummyEntityItem = new px(null);
    private final bce customRenderItem;
    private HashMap displayLiquidLists = new HashMap();
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final int POWER_STAGES = 100;
    public int[] displayPowerList = new int[100];
    public int[] displayPowerListOverload = new int[100];
    boolean initialized = false;

    public RenderPipe() {
        this.customRenderItem = new bce(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.a(bbu.a);
    }

    private DisplayLiquidList getDisplayLiquidLists(int liquidId, int meta, yc world) {
        if (this.displayLiquidLists.containsKey(liquidId)) {
            HashMap x = (HashMap)this.displayLiquidLists.get(liquidId);
            if (x.containsKey(meta)) {
                return (DisplayLiquidList)x.get(meta);
            }
        } else {
            this.displayLiquidLists.put(liquidId, new HashMap());
        }
        DisplayLiquidList d = new DisplayLiquidList();
        ((HashMap)this.displayLiquidLists.get(liquidId)).put(meta, d);
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = liquidId < amq.p.length && amq.p[liquidId] != null ? amq.p[liquidId].a(0, meta) : up.e[liquidId].b(meta);
        float size = 0.5f;
        for (int s2 = 0; s2 < 40; ++s2) {
            float ratio = (float)s2 / 40.0f;
            d.sideHorizontal[s2] = arx.a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s2], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock(block, (ym)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s2] = arx.a((int)1);
            GL11.glNewList((int)d.sideVertical[s2], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.renderBlock(block, (ym)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s2] = arx.a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s2], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock(block, (ym)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s2] = arx.a((int)1);
            GL11.glNewList((int)d.centerVertical[s2], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.renderBlock(block, (ym)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    private void initializeDisplayPowerList(yc world) {
        float unit;
        float minSize;
        int s2;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = 4;
        float size = 0.5f;
        for (s2 = 0; s2 < 100; ++s2) {
            this.displayPowerList[s2] = arx.a((int)1);
            GL11.glNewList((int)this.displayPowerList[s2], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s2);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s2);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s2);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s2);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s2);
            RenderEntityBlock.renderBlock(block, (ym)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        block.texture = 6;
        size = 0.5f;
        for (s2 = 0; s2 < 100; ++s2) {
            this.displayPowerListOverload[s2] = arx.a((int)1);
            GL11.glNewList((int)this.displayPowerListOverload[s2], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s2);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s2);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s2);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s2);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s2);
            RenderEntityBlock.renderBlock(block, (ym)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
    }

    public void a(any tileentity, double x, double y2, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        this.initializeDisplayPowerList(tileentity.k);
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.transport instanceof PipeTransportItems) {
            this.renderSolids(pipe.pipe, x, y2, z);
        } else if (pipe.pipe.transport instanceof PipeTransportLiquids) {
            this.renderLiquids(pipe.pipe, x, y2, z);
        } else if (pipe.pipe.transport instanceof PipeTransportPower) {
            this.renderPower(pipe.pipe, x, y2, z);
        }
    }

    private void renderPower(Pipe pipe, double x, double y2, double z) {
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        ForgeHooksClient.bindTexture((String)DefaultProps.TEXTURE_BLOCKS, (int)0);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y2 + 0.5f), (float)((float)z + 0.5f));
        int[] displayList = pow.overload ? this.displayPowerListOverload : this.displayPowerList;
        for (int i = 0; i < 6; ++i) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
            if ((double)pow.displayPower[i] >= 1.0) {
                short stage = pow.displayPower[i];
                if (stage < displayList.length) {
                    GL11.glCallList((int)displayList[stage]);
                } else {
                    GL11.glCallList((int)displayList[displayList.length - 1]);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderLiquids(Pipe pipe, double x, double y2, double z) {
        DisplayLiquidList d;
        PipeTransportLiquids liq = (PipeTransportLiquids)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y2 + 0.5f), (float)((float)z + 0.5f));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayLiquidList d2;
            LiquidStack liquid = liq.renderCache[i];
            if (liquid == null || liquid.amount <= 0 || (d2 = this.getListFromBuffer(liquid, pipe.worldObj)) == null) continue;
            int stage = (int)((float)liquid.amount / (float)liq.getCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        LiquidStack liquid = liq.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (liquid != null && liquid.amount > 0 && (d = this.getListFromBuffer(liquid, pipe.worldObj)) != null) {
            int stage = (int)((float)liquid.amount / (float)liq.getCapacity() * 39.0f);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private DisplayLiquidList getListFromBuffer(LiquidStack stack, yc world) {
        int liquidId = stack.itemID;
        if (liquidId == 0) {
            return null;
        }
        if (liquidId < amq.p.length && amq.p[liquidId] != null) {
            ForgeHooksClient.bindTexture((String)amq.p[liquidId].getTextureFile(), (int)0);
        } else if (up.e[liquidId] != null) {
            ForgeHooksClient.bindTexture((String)up.e[liquidId].getTextureFile(), (int)0);
        } else {
            return null;
        }
        return this.getDisplayLiquidLists(liquidId, stack.itemMeta, world);
    }

    private void renderSolids(Pipe pipe, double x, double y2, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float light = pipe.worldObj.p(pipe.xCoord, pipe.yCoord, pipe.zCoord);
        int count = 0;
        for (EntityData data : ((PipeTransportItems)pipe.transport).travelingEntities.values()) {
            if (count >= 10) break;
            this.doRenderItem(data.item, x + data.item.getPosition().x - (double)pipe.xCoord, y2 + data.item.getPosition().y - (double)pipe.yCoord, z + data.item.getPosition().z - (double)pipe.zCoord, light);
            ++count;
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void doRenderItem(IPipedItem entityitem, double d, double d1, double d2, float f1) {
        if (entityitem == null || entityitem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ur itemstack = entityitem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.a(itemstack);
        this.customRenderItem.a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    private class DisplayLiquidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayLiquidList() {
        }
    }
}

