/*
 * Decompiled with CFR 0.152.
 */
package energyintegrations;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.Electricity;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.vector.Vector3;

public class IC2Integration {
    public static final List ENERGY_TILE = new ArrayList();
    public static final List CONDUCTORS = new ArrayList();

    @ForgeSubscribe
    public void EnergyTileEvent(EnergyTileLoadEvent evt) {
        any energyTile = (any)evt.energyTile;
        ElectricityConnections.registerConnector(energyTile, EnumSet.range(ForgeDirection.DOWN, ForgeDirection.EAST));
        if (!energyTile.k.I) {
            for (int i = 0; i < 6; ++i) {
                Vector3 position = new Vector3(energyTile);
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                position.modifyPositionFromSide(direction);
                any tileEntity = position.getTileEntity((ym)energyTile.k);
                if (tileEntity == null || !(tileEntity instanceof IConductor)) continue;
                ((IConductor)tileEntity).refreshConnectedBlocks();
            }
        }
        ENERGY_TILE.add(energyTile);
    }

    @ForgeSubscribe
    public void EnergyTileEvent(EnergyTileSourceEvent evt) {
        any tileEntity = (any)evt.energyTile;
        if (!tileEntity.k.I) {
            ArrayList<ElectricityNetwork> connectedNetworks = new ArrayList<ElectricityNetwork>();
            for (int i = 0; i < 6; ++i) {
                Vector3 position = new Vector3(tileEntity);
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                position.modifyPositionFromSide(direction);
                any outputConductor = position.getTileEntity((ym)tileEntity.k);
                ElectricityNetwork electricityNetwork = ElectricityNetwork.getNetworkFromTileEntity(outputConductor, direction);
                if (electricityNetwork == null || connectedNetworks.contains(connectedNetworks)) continue;
                if (((IEnergySource)tileEntity).emitsEnergyTo(outputConductor, IC2Integration.getIC2Direction(direction))) {
                    connectedNetworks.add(electricityNetwork);
                    continue;
                }
                electricityNetwork.stopProducing(tileEntity);
            }
            if (connectedNetworks.size() > 0) {
                double wattsPerNetwork = (double)evt.amount * UniversalElectricity.IC2_RATIO / (double)connectedNetworks.size();
                double voltage = 120.0;
                for (ElectricityNetwork network : connectedNetworks) {
                    if (evt.amount >= ((IEnergySource)tileEntity).getMaxEnergyOutput() && network.getRequest().getWatts() > 1.0) {
                        network.startProducing(tileEntity, wattsPerNetwork / voltage, voltage);
                        evt.amount = (int)((double)evt.amount - wattsPerNetwork * UniversalElectricity.TO_IC2_RATIO);
                        continue;
                    }
                    network.stopProducing(tileEntity);
                }
            }
        }
    }

    @ForgeSubscribe
    public void EnergyTileEvent(EnergyTileUnloadEvent evt) {
        ElectricityConnections.registerConnector((any)evt.energyTile, EnumSet.of(ForgeDirection.UNKNOWN));
        Electricity.instance.unregister((any)evt.energyTile);
    }

    public static Direction getIC2Direction(ForgeDirection direction) {
        int i = direction.ordinal() + 2;
        if (i < 0) {
            i += 6;
        }
        if (i > 5) {
            i -= 6;
        }
        return Direction.values()[i];
    }
}

