/*
 * Decompiled with CFR 0.152.
 */
package energyintegrations;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import energyintegrations.IC2Integration;
import ic2.api.energy.tile.IEnergySink;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.vector.Vector3;

public class Ticker
implements ITickHandler {
    public static final Ticker INSTANCE = new Ticker();

    public void tickStart(EnumSet type, Object ... tickData) {
        try {
            for (Object object : IC2Integration.ENERGY_TILE) {
                any tileEntity;
                if (object == null || !(object instanceof any) || (tileEntity = (any)object).r() || !(tileEntity instanceof IEnergySink)) continue;
                IEnergySink sink = (IEnergySink)object;
                if (tileEntity.k.I) continue;
                HashMap<ElectricityNetwork, ForgeDirection> connectedNetworks = new HashMap<ElectricityNetwork, ForgeDirection>();
                for (int i = 0; i < 6; ++i) {
                    Vector3 position = new Vector3(tileEntity);
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    position.modifyPositionFromSide(direction);
                    any inputConductor = position.getTileEntity((ym)tileEntity.k);
                    ElectricityNetwork electricityNetwork = ElectricityNetwork.getNetworkFromTileEntity(inputConductor, direction);
                    if (electricityNetwork == null || connectedNetworks.containsKey(connectedNetworks) || !sink.acceptsEnergyFrom(tileEntity, IC2Integration.getIC2Direction(direction))) continue;
                    connectedNetworks.put(electricityNetwork, direction.getOpposite());
                }
                double wattsPerNetwork = (double)Math.min(sink.demandsEnergy(), sink.getMaxSafeInput()) * UniversalElectricity.IC2_RATIO / (double)connectedNetworks.size();
                double voltage = 120.0;
                for (Map.Entry pairs : connectedNetworks.entrySet()) {
                    ElectricityNetwork network = (ElectricityNetwork)pairs.getKey();
                    ForgeDirection direction = (ForgeDirection)pairs.getValue();
                    if (sink.demandsEnergy() > 0) {
                        network.startRequesting(tileEntity, wattsPerNetwork / voltage, voltage);
                        double consumedEnergy = UniversalElectricity.TO_IC2_RATIO * network.consumeElectricity(tileEntity).getWatts();
                        sink.injectEnergy(IC2Integration.getIC2Direction(direction), (int)Math.min(consumedEnergy, (double)sink.getMaxSafeInput()));
                        continue;
                    }
                    network.stopProducing(tileEntity);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error while ticking Energy Integration module.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "Energy Integrations";
    }
}

