/*
 * Decompiled with CFR 0.152.
 */
package basiccomponents.common.tileentity;

import basiccomponents.common.BasicComponents;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.LanguageRegistry;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.EnumSet;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import universalelectricity.core.electricity.ElectricInfo;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.implement.IItemElectric;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.implement.IRedstoneProvider;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityElectricityReceiver;

public class TileEntityBatteryBox
extends TileEntityElectricityReceiver
implements IJouleStorage,
IPacketReceiver,
IRedstoneProvider,
la,
ISidedInventory,
IPeripheral {
    private double joules = 0.0;
    private ur[] containingItems = new ur[2];
    private boolean isFull = false;
    private int playersUsing = 0;

    @Override
    public void initiate() {
        ElectricityConnections.registerConnector(this, EnumSet.of(ForgeDirection.getOrientation((int)(this.p() - 4 + 2)), ForgeDirection.getOrientation((int)(this.p() - 4 + 2)).getOpposite()));
        this.k.h(this.l, this.m, this.n, BasicComponents.blockMachine.cm);
    }

    @Override
    public void g() {
        super.g();
        if (!this.isDisabled()) {
            ForgeDirection outputDirection;
            any outputTile;
            ElectricityNetwork outputNetwork;
            IItemElectric electricItem;
            ForgeDirection inputDirection = ForgeDirection.getOrientation((int)(this.p() - 4 + 2)).getOpposite();
            any inputTile = Vector3.getTileEntityFromSide(this.k, new Vector3(this), inputDirection);
            ElectricityNetwork inputNetwork = ElectricityNetwork.getNetworkFromTileEntity(inputTile, inputDirection);
            if (!this.k.I && inputNetwork != null) {
                if (this.joules >= this.getMaxJoules(new Object[0])) {
                    inputNetwork.stopRequesting(this);
                } else {
                    inputNetwork.startRequesting(this, Math.min(this.getMaxJoules(new Object[0]) - this.getJoules(new Object[0]), 2500.0) / this.getVoltage(), this.getVoltage());
                    this.setJoules(this.joules + inputNetwork.consumeElectricity(this).getWatts(), new Object[0]);
                }
            }
            if (this.containingItems[0] != null && this.joules > 0.0 && this.containingItems[0].b() instanceof IItemElectric) {
                IItemElectric electricItem2 = (IItemElectric)this.containingItems[0].b();
                double ampsToGive = Math.min(ElectricInfo.getAmps(electricItem2.getMaxJoules(this.containingItems[0]) * 0.005, this.getVoltage()), this.joules);
                double joules = electricItem2.onReceive(ampsToGive, this.getVoltage(), this.containingItems[0]);
                this.setJoules(this.joules - (ElectricInfo.getJoules(ampsToGive, this.getVoltage(), 1.0) - joules), new Object[0]);
            }
            boolean isFullThisCheck = false;
            if (this.joules >= this.getMaxJoules(new Object[0])) {
                isFullThisCheck = true;
            }
            if (this.isFull != isFullThisCheck) {
                this.isFull = isFullThisCheck;
                this.k.h(this.l, this.m, this.n, BasicComponents.blockMachine.cm);
            }
            if (this.containingItems[1] != null && this.joules < this.getMaxJoules(new Object[0]) && this.containingItems[1].b() instanceof IItemElectric && (electricItem = (IItemElectric)this.containingItems[1].b()).canProduceElectricity()) {
                double joulesReceived = electricItem.onUse(electricItem.getMaxJoules(this.containingItems[1]) * 0.005, this.containingItems[1]);
                this.setJoules(this.joules + joulesReceived, new Object[0]);
            }
            if (!this.k.I && (outputNetwork = ElectricityNetwork.getNetworkFromTileEntity(outputTile = Vector3.getTileEntityFromSide(this.k, new Vector3(this), outputDirection = ForgeDirection.getOrientation((int)(this.p() - 4 + 2))), outputDirection)) != null && inputNetwork != outputNetwork) {
                double outputWatts = Math.min(outputNetwork.getRequest().getWatts(), Math.min(this.getJoules(new Object[0]), 2500.0));
                if (this.getJoules(new Object[0]) > 0.0 && outputWatts > 0.0) {
                    outputNetwork.startProducing(this, outputWatts / this.getVoltage(), this.getVoltage());
                    this.setJoules(this.joules - outputWatts, new Object[0]);
                } else {
                    outputNetwork.stopProducing(this);
                }
            }
        }
        this.setJoules(this.joules - 5.0E-4, new Object[0]);
        if (!this.k.I && this.ticks % 3L == 0L && this.playersUsing > 0) {
            PacketManager.sendPacketToClients(this.l(), this.k, new Vector3(this), 12.0);
        }
    }

    public ef l() {
        return PacketManager.getPacket("BasicComponents", this, new Object[]{this.joules, this.disabledTicks});
    }

    @Override
    public void handlePacketData(ce network, int type, di packet, qx player, ByteArrayDataInput dataStream) {
        try {
            this.joules = dataStream.readDouble();
            this.disabledTicks = dataStream.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void l_() {
        ++this.playersUsing;
    }

    public void f() {
        --this.playersUsing;
    }

    public void a(bq par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.joules = par1NBTTagCompound.h("electricityStored");
        by var2 = par1NBTTagCompound.m("Items");
        this.containingItems = new ur[this.k_()];
        for (int var3 = 0; var3 < var2.c(); ++var3) {
            bq var4 = (bq)var2.b(var3);
            byte var5 = var4.c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ur.a((bq)var4);
        }
    }

    public void b(bq par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("electricityStored", this.joules);
        by var2 = new by();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            bq var4 = new bq();
            var4.a("Slot", (byte)var3);
            this.containingItems[var3].b(var4);
            var2.a((cd)var4);
        }
        par1NBTTagCompound.a("Items", (cd)var2);
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        if (side == ForgeDirection.UP) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int k_() {
        return this.containingItems.length;
    }

    public ur a(int par1) {
        return this.containingItems[par1];
    }

    public ur a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].a <= par2) {
                ur var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ur var3 = this.containingItems[par1].a(par2);
            if (this.containingItems[par1].a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ur a_(int par1) {
        if (this.containingItems[par1] != null) {
            ur var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, ur par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.c()) {
            par2ItemStack.a = this.c();
        }
    }

    public String b() {
        return LanguageRegistry.instance().getStringLocalization("tile.bcMachine.1.name");
    }

    public int c() {
        return 1;
    }

    public boolean a_(qx par1EntityPlayer) {
        return this.k.q(this.l, this.m, this.n) != this ? false : par1EntityPlayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    @Override
    public boolean isPoweringTo(ForgeDirection side) {
        return this.isFull;
    }

    @Override
    public boolean isIndirectlyPoweringTo(ForgeDirection side) {
        return this.isPoweringTo(side);
    }

    @Override
    public double getJoules(Object ... data) {
        return this.joules;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.joules = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return 4000000.0;
    }

    @Override
    public String getType() {
        return "BatteryBox";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getVoltage", "getJoules", "isFull"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getVoltage()};
            }
            case 1: {
                return new Object[]{this.getJoules(new Object[0])};
            }
            case 2: {
                return new Object[]{this.isFull};
            }
        }
        throw new Exception("Function unimplemented");
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer, String computerSide) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }
}

