/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class CustomColorizer {
    private static int[] grassColors = null;
    private static int[] waterColors = null;
    private static int[] foliageColors = null;
    private static int[] foliagePineColors = null;
    private static int[] foliageBirchColors = null;
    private static int[] swampFoliageColors = null;
    private static int[] swampGrassColors = null;
    private static int[][] blockPalettes = null;
    private static int[][] paletteColors = null;
    private static int[] skyColors = null;
    private static int[] fogColors = null;
    private static int[] underwaterColors = null;
    private static float[][][] lightMapsColorsRgb = null;
    private static int[] lightMapsHeight = null;
    private static float[][] sunRgbs = new float[16][3];
    private static float[][] torchRgbs = new float[16][3];
    private static int[] redstoneColors = null;
    private static int[] stemColors = null;
    private static int[] myceliumParticleColors = null;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static aoj fogColorNether = null;
    private static aoj fogColorEnd = null;
    private static aoj skyColorEnd = null;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_GRASS = 1;
    private static final int TYPE_FOLIAGE = 2;
    private static Random random = new Random();

    public static void update(bba re2) {
        grassColors = null;
        waterColors = null;
        foliageColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        redstoneColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapsColorsRgb = null;
        lightMapsHeight = null;
        lilyPadColor = -1;
        particleWaterColor = -1;
        particlePortalColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        blockPalettes = null;
        paletteColors = null;
        grassColors = CustomColorizer.getCustomColors("/misc/grasscolor.png", re2, 65536);
        foliageColors = CustomColorizer.getCustomColors("/misc/foliagecolor.png", re2, 65536);
        waterColors = CustomColorizer.getCustomColors("/misc/watercolorX.png", re2, 65536);
        if (!Config.isCustomColors()) {
            return;
        }
        foliagePineColors = CustomColorizer.getCustomColors("/misc/pinecolor.png", re2, 65536);
        foliageBirchColors = CustomColorizer.getCustomColors("/misc/birchcolor.png", re2, 65536);
        swampGrassColors = CustomColorizer.getCustomColors("/misc/swampgrasscolor.png", re2, 65536);
        swampFoliageColors = CustomColorizer.getCustomColors("/misc/swampfoliagecolor.png", re2, 65536);
        skyColors = CustomColorizer.getCustomColors("/misc/skycolor0.png", re2, 65536);
        fogColors = CustomColorizer.getCustomColors("/misc/fogcolor0.png", re2, 65536);
        underwaterColors = CustomColorizer.getCustomColors("/misc/underwatercolor.png", re2, 65536);
        redstoneColors = CustomColorizer.getCustomColors("/misc/redstonecolor.png", re2, 16);
        stemColors = CustomColorizer.getCustomColors("/misc/stemcolor.png", re2, 8);
        myceliumParticleColors = CustomColorizer.getCustomColors("/misc/myceliumparticlecolor.png", re2, -1);
        int[][] lightMapsColors = new int[3][];
        lightMapsColorsRgb = new float[3][][];
        lightMapsHeight = new int[3];
        for (int i2 = 0; i2 < lightMapsColors.length; ++i2) {
            String path = "/environment/lightmap" + (i2 - 1) + ".png";
            lightMapsColors[i2] = CustomColorizer.getCustomColors(path, re2, -1);
            if (lightMapsColors[i2] != null) {
                CustomColorizer.lightMapsColorsRgb[i2] = CustomColorizer.toRgb(lightMapsColors[i2]);
            }
            CustomColorizer.lightMapsHeight[i2] = CustomColorizer.getTextureHeight(re2, path, 32);
        }
        CustomColorizer.readColorProperties("/color.properties", re2);
    }

    private static int getTextureHeight(bba re2, String path, int defHeight) {
        try {
            BufferedImage bi2 = re2.readTextureImage(path);
            if (bi2 == null) {
                return defHeight;
            }
            return bi2.getHeight();
        }
        catch (IOException e2) {
            return defHeight;
        }
    }

    private static float[][] toRgb(int[] cols) {
        float[][] colsRgb = new float[cols.length][3];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            int col = cols[i2];
            float rf2 = (float)(col >> 16 & 0xFF) / 255.0f;
            float gf2 = (float)(col >> 8 & 0xFF) / 255.0f;
            float bf2 = (float)(col & 0xFF) / 255.0f;
            float[] colRgb = colsRgb[i2];
            colRgb[0] = rf2;
            colRgb[1] = gf2;
            colRgb[2] = bf2;
        }
        return colsRgb;
    }

    private static void readColorProperties(String fileName, bba re2) {
        InputStream in2 = re2.getTexturePack().e().a(fileName);
        if (in2 == null) {
            return;
        }
        try {
            Config.log("Loading " + fileName);
            Properties props = new Properties();
            props.load(in2);
            lilyPadColor = CustomColorizer.readColor(props, "lilypad");
            particleWaterColor = CustomColorizer.readColor(props, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColorizer.readColor(props, "particle.portal");
            fogColorNether = CustomColorizer.readColorVec3(props, "fog.nether");
            fogColorEnd = CustomColorizer.readColorVec3(props, "fog.end");
            skyColorEnd = CustomColorizer.readColorVec3(props, "sky.end");
            CustomColorizer.readCustomPalettes(props, re2);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readCustomPalettes(Properties props, bba re2) {
        void var6_9;
        blockPalettes = new int[256][1];
        for (int i2 = 0; i2 < 256; ++i2) {
            CustomColorizer.blockPalettes[i2][0] = -1;
        }
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        paletteColors = new int[propNames.length][];
        boolean bl = false;
        while (var6_9 < propNames.length) {
            String name = propNames[var6_9];
            String value = props.getProperty(name);
            Config.log("Block palette: " + name + " = " + value);
            String path = name.substring(palettePrefix.length());
            int[] colors = CustomColorizer.getCustomColors(path, re2, 65536);
            CustomColorizer.paletteColors[var6_9] = colors;
            String[] indexStrs = Config.tokenize(value, " ,;");
            for (int ix2 = 0; ix2 < indexStrs.length; ++ix2) {
                int blockIndex;
                String blockStr = indexStrs[ix2];
                int metadata = -1;
                if (blockStr.contains(":")) {
                    String[] blockStrs = Config.tokenize(blockStr, ":");
                    blockStr = blockStrs[0];
                    String metadataStr = blockStrs[1];
                    metadata = Config.parseInt(metadataStr, -1);
                    if (metadata < 0 || metadata > 15) {
                        Config.log("Invalid block metadata: " + blockStr + " in palette: " + name);
                        continue;
                    }
                }
                if ((blockIndex = Config.parseInt(blockStr, -1)) < 0 || blockIndex > 255) {
                    Config.log("Invalid block index: " + blockIndex + " in palette: " + name);
                    continue;
                }
                if (blockIndex == amq.x.cm || blockIndex == amq.aa.cm || blockIndex == amq.N.cm || blockIndex == amq.bx.cm) continue;
                if (metadata == -1) {
                    CustomColorizer.blockPalettes[blockIndex][0] = var6_9;
                    continue;
                }
                if (blockPalettes[blockIndex].length < 16) {
                    CustomColorizer.blockPalettes[blockIndex] = new int[16];
                    Arrays.fill(blockPalettes[blockIndex], -1);
                }
                CustomColorizer.blockPalettes[blockIndex][metadata] = var6_9;
            }
            ++var6_9;
        }
    }

    private static int readColor(Properties props, String[] names) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            int col = CustomColorizer.readColor(props, name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            Config.log("Custom color: " + name + " = " + str);
            return val;
        }
        catch (NumberFormatException e2) {
            Config.log("Invalid custom color: " + name + " = " + str);
            return -1;
        }
    }

    private static aoj readColorVec3(Properties props, String name) {
        int col = CustomColorizer.readColor(props, name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return aoj.a(redF, greenF, blueF);
    }

    private static int[] getCustomColors(String path, bba re2, int length) {
        InputStream in2 = re2.getTexturePack().e().a(path);
        if (in2 == null) {
            return null;
        }
        int[] colors = re2.a(path);
        if (colors == null) {
            return null;
        }
        if (length > 0 && colors.length != length) {
            Config.log("Invalid custom colors length: " + colors.length + ", path: " + path);
            return null;
        }
        Config.log("Loading custom colors: " + path);
        return colors;
    }

    public static int getColorMultiplier(amq block, ym blockAccess, int x2, int y2, int z2) {
        int metadata;
        if (foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && blockPalettes == null && Config.isSwampColors() && Config.isSmoothBiomes()) {
            return block.b(blockAccess, x2, y2, z2);
        }
        int[] colors = null;
        int[] swampColors = null;
        if (blockPalettes != null) {
            int blockId = block.cm;
            if (blockId >= 0 && blockId < 256) {
                int[] metadataPals = blockPalettes[blockId];
                int paletteIx = -1;
                if (metadataPals.length > 1) {
                    metadata = blockAccess.h(x2, y2, z2);
                    paletteIx = metadataPals[metadata];
                } else {
                    paletteIx = metadataPals[0];
                }
                if (paletteIx >= 0) {
                    colors = paletteColors[paletteIx];
                }
            }
            if (colors != null) {
                if (Config.isSmoothBiomes()) {
                    return CustomColorizer.getSmoothColorMultiplier(block, blockAccess, x2, y2, z2, colors, swampColors, 0, 0);
                }
                return CustomColorizer.getCustomColor(colors, blockAccess, x2, y2, z2);
            }
        }
        boolean useSwampColors = Config.isSwampColors();
        boolean smoothColors = false;
        int type = 0;
        metadata = 0;
        if (block == amq.x || block == amq.aa) {
            type = 1;
            smoothColors = Config.isSmoothBiomes();
            colors = grassColors;
            swampColors = useSwampColors ? swampGrassColors : colors;
        } else if (block == amq.N) {
            type = 2;
            smoothColors = Config.isSmoothBiomes();
            metadata = blockAccess.h(x2, y2, z2);
            if ((metadata & 3) == 1) {
                colors = foliagePineColors;
            } else if ((metadata & 3) == 2) {
                colors = foliageBirchColors;
            } else {
                colors = foliageColors;
                swampColors = useSwampColors ? swampFoliageColors : colors;
            }
        } else if (block == amq.bx) {
            type = 2;
            smoothColors = Config.isSmoothBiomes();
            colors = foliageColors;
            swampColors = useSwampColors ? swampFoliageColors : colors;
        }
        if (smoothColors) {
            return CustomColorizer.getSmoothColorMultiplier(block, blockAccess, x2, y2, z2, colors, swampColors, type, metadata);
        }
        if (swampColors != colors && blockAccess.a(x2, z2) == yy.h) {
            colors = swampColors;
        }
        if (colors != null) {
            return CustomColorizer.getCustomColor(colors, blockAccess, x2, y2, z2);
        }
        return block.b(blockAccess, x2, y2, z2);
    }

    private static int getSmoothColorMultiplier(amq block, ym blockAccess, int x2, int y2, int z2, int[] colors, int[] swampColors, int type, int metadata) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        for (int ix2 = x2 - 1; ix2 <= x2 + 1; ++ix2) {
            for (int iz2 = z2 - 1; iz2 <= z2 + 1; ++iz2) {
                int[] cols = colors;
                if (swampColors != cols && blockAccess.a(ix2, iz2) == yy.h) {
                    cols = swampColors;
                }
                int col = 0;
                if (cols == null) {
                    switch (type) {
                        case 1: {
                            col = blockAccess.a(ix2, iz2).k();
                            break;
                        }
                        case 2: {
                            if ((metadata & 3) == 1) {
                                col = xy.a();
                                break;
                            }
                            if ((metadata & 3) == 2) {
                                col = xy.b();
                                break;
                            }
                            col = blockAccess.a(ix2, iz2).l();
                            break;
                        }
                        default: {
                            col = block.b(blockAccess, ix2, y2, iz2);
                            break;
                        }
                    }
                } else {
                    col = CustomColorizer.getCustomColor(cols, blockAccess, ix2, y2, iz2);
                }
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r2 = sumRed / 9;
        int g2 = sumGreen / 9;
        int b2 = sumBlue / 9;
        return r2 << 16 | g2 << 8 | b2;
    }

    public static int getFluidColor(amq block, ym blockAccess, int x2, int y2, int z2) {
        if (block.cB != agi.h) {
            return block.b(blockAccess, x2, y2, z2);
        }
        if (waterColors != null) {
            if (Config.isSmoothBiomes()) {
                return CustomColorizer.getSmoothColor(waterColors, blockAccess, x2, y2, z2, 3, 1);
            }
            return CustomColorizer.getCustomColor(waterColors, blockAccess, x2, y2, z2);
        }
        if (!Config.isSwampColors()) {
            return 0xFFFFFF;
        }
        return block.b(blockAccess, x2, y2, z2);
    }

    private static int getCustomColor(int[] colors, ym blockAccess, int x2, int y2, int z2) {
        yy bgb = blockAccess.a(x2, z2);
        double temperature = ke.a(bgb.j(), 0.0f, 1.0f);
        double rainfall = ke.a(bgb.i(), 0.0f, 1.0f);
        int cx2 = (int)((1.0 - temperature) * 255.0);
        int cy2 = (int)((1.0 - (rainfall *= temperature)) * 255.0);
        return colors[cy2 << 8 | cx2] & 0xFFFFFF;
    }

    public static void updatePortalFX(azq fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.h = redF;
        fx.i = greenF;
        fx.j = blueF;
    }

    public static void updateMyceliumFX(azq fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors[random.nextInt(myceliumParticleColors.length)];
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.h = redF;
        fx.i = greenF;
        fx.j = blueF;
    }

    public static void updateReddustFX(azq fx, ym blockAccess, double x2, double y2, double z2) {
        if (redstoneColors == null) {
            return;
        }
        int level = blockAccess.h((int)x2, (int)y2, (int)z2);
        int col = CustomColorizer.getRedstoneColor(level);
        if (col == -1) {
            return;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.h = redF;
        fx.i = greenF;
        fx.j = blueF;
    }

    public static int getRedstoneColor(int level) {
        if (redstoneColors == null) {
            return -1;
        }
        if (level < 0 || level > 15) {
            return -1;
        }
        return redstoneColors[level] & 0xFFFFFF;
    }

    public static void updateWaterFX(azq fx, ym blockAccess) {
        if (waterColors == null) {
            return;
        }
        int x2 = (int)fx.t;
        int y2 = (int)fx.u;
        int z2 = (int)fx.v;
        int col = CustomColorizer.getFluidColor(amq.E, blockAccess, x2, y2, z2);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.h = redF;
        fx.i = greenF;
        fx.j = blueF;
    }

    public static int getLilypadColor() {
        if (lilyPadColor < 0) {
            return amq.bC.o();
        }
        return lilyPadColor;
    }

    public static aoj getFogColorNether(aoj col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    public static aoj getFogColorEnd(aoj col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    public static aoj getSkyColorEnd(aoj col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static aoj getSkyColor(aoj skyColor3d, ym blockAccess, double x2, double y2, double z2) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = CustomColorizer.getSmoothColor(skyColors, blockAccess, x2, y2, z2, 10, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.c / 0.5f;
        float cGreen = (float)skyColor3d.d / 0.66275f;
        float cBlue = (float)skyColor3d.e;
        return aoj.a(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
    }

    public static aoj getFogColor(aoj fogColor3d, ym blockAccess, double x2, double y2, double z2) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = CustomColorizer.getSmoothColor(fogColors, blockAccess, x2, y2, z2, 10, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.c / 0.753f;
        float cGreen = (float)fogColor3d.d / 0.8471f;
        float cBlue = (float)fogColor3d.e;
        return aoj.a(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
    }

    public static aoj getUnderwaterColor(ym blockAccess, double x2, double y2, double z2) {
        if (underwaterColors == null) {
            return null;
        }
        int col = CustomColorizer.getSmoothColor(underwaterColors, blockAccess, x2, y2, z2, 10, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return aoj.a(redF, greenF, blueF);
    }

    public static int getSmoothColor(int[] colors, ym blockAccess, double x2, double y2, double z2, int samples, int step) {
        if (colors == null) {
            return -1;
        }
        int x0 = (int)Math.floor(x2);
        int y0 = (int)Math.floor(y2);
        int z0 = (int)Math.floor(z2);
        int n2 = samples * step / 2;
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int count = 0;
        for (int ix2 = x0 - n2; ix2 <= x0 + n2; ix2 += step) {
            for (int iz2 = z0 - n2; iz2 <= z0 + n2; iz2 += step) {
                int col = CustomColorizer.getCustomColor(colors, blockAccess, ix2, y0, iz2);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
                ++count;
            }
        }
        int r2 = sumRed / count;
        int g2 = sumGreen / count;
        int b2 = sumBlue / count;
        return r2 << 16 | g2 << 8 | b2;
    }

    public static int mixColors(int c1, int c2, float w1) {
        if (w1 <= 0.0f) {
            return c2;
        }
        if (w1 >= 1.0f) {
            return c1;
        }
        float w2 = 1.0f - w1;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = (int)((float)r1 * w1 + (float)r2 * w2);
        int g3 = (int)((float)g1 * w1 + (float)g2 * w2);
        int b3 = (int)((float)b1 * w1 + (float)b2 * w2);
        return r3 << 16 | g3 << 8 | b3;
    }

    private static int averageColor(int c1, int c2) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = (r1 + r2) / 2;
        int g3 = (g1 + g2) / 2;
        int b3 = (b1 + b2) / 2;
        return r3 << 16 | g3 << 8 | b3;
    }

    public static int getStemColorMultiplier(ami blockStem, ym blockAccess, int x2, int y2, int z2) {
        if (stemColors == null) {
            return blockStem.b(blockAccess, x2, y2, z2);
        }
        int level = blockAccess.h(x2, y2, z2);
        if (level < 0) {
            level = 0;
        }
        if (level >= stemColors.length) {
            level = stemColors.length - 1;
        }
        return stemColors[level];
    }

    public static boolean updateLightmap(yc world, ban entityRenderer, int[] lmColors, boolean nightvision) {
        if (world == null) {
            return false;
        }
        if (lightMapsColorsRgb == null) {
            return false;
        }
        if (!Config.isCustomColors()) {
            return false;
        }
        int worldType = world.u.h;
        if (worldType < -1 || worldType > 1) {
            return false;
        }
        int lightMapIndex = worldType + 1;
        float[][] lightMapRgb = lightMapsColorsRgb[lightMapIndex];
        if (lightMapRgb == null) {
            return false;
        }
        int height = lightMapsHeight[lightMapIndex];
        if (nightvision && height < 64) {
            return false;
        }
        int width = lightMapRgb.length / height;
        if (width < 16) {
            Config.dbg("Invalid lightmap width: " + width + " for: /environment/lightmap" + worldType + ".png");
            CustomColorizer.lightMapsColorsRgb[lightMapIndex] = null;
            return false;
        }
        int startIndex = 0;
        if (nightvision) {
            startIndex = width * 16 * 2;
        }
        float sun = 1.1666666f * (world.b(1.0f) - 0.2f);
        if (world.q > 0) {
            sun = 1.0f;
        }
        sun = Config.limitTo1(sun);
        float sunX = sun * (float)(width - 1);
        float torchX = Config.limitTo1(entityRenderer.e + 0.5f) * (float)(width - 1);
        float gamma = Config.limitTo1(Config.getMinecraft().y.ag);
        boolean hasGamma = gamma > 1.0E-4f;
        CustomColorizer.getLightMapColumn(lightMapRgb, sunX, startIndex, width, sunRgbs);
        CustomColorizer.getLightMapColumn(lightMapRgb, torchX, startIndex + 16 * width, width, torchRgbs);
        float[] rgb = new float[3];
        for (int is2 = 0; is2 < 16; ++is2) {
            for (int it2 = 0; it2 < 16; ++it2) {
                for (int ic = 0; ic < 3; ++ic) {
                    float comp = Config.limitTo1(sunRgbs[is2][ic] + torchRgbs[it2][ic]);
                    if (hasGamma) {
                        float cg2 = 1.0f - comp;
                        cg2 = 1.0f - cg2 * cg2 * cg2 * cg2;
                        comp = gamma * cg2 + (1.0f - gamma) * comp;
                    }
                    rgb[ic] = comp;
                }
                int r2 = (int)(rgb[0] * 255.0f);
                int g2 = (int)(rgb[1] * 255.0f);
                int b2 = (int)(rgb[2] * 255.0f);
                lmColors[is2 * 16 + it2] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
            }
        }
        return true;
    }

    private static void getLightMapColumn(float[][] origMap, float x2, int offset, int width, float[][] colRgb) {
        int xHigh;
        int xLow = (int)Math.floor(x2);
        if (xLow == (xHigh = (int)Math.ceil(x2))) {
            for (int y2 = 0; y2 < 16; ++y2) {
                float[] rgbLow = origMap[offset + y2 * width + xLow];
                float[] rgb = colRgb[y2];
                for (int i2 = 0; i2 < 3; ++i2) {
                    rgb[i2] = rgbLow[i2];
                }
            }
            return;
        }
        float dLow = 1.0f - (x2 - (float)xLow);
        float dHigh = 1.0f - ((float)xHigh - x2);
        for (int y3 = 0; y3 < 16; ++y3) {
            float[] rgbLow = origMap[offset + y3 * width + xLow];
            float[] rgbHigh = origMap[offset + y3 * width + xHigh];
            float[] rgb = colRgb[y3];
            for (int i3 = 0; i3 < 3; ++i3) {
                rgb[i3] = rgbLow[i3] * dLow + rgbHigh[i3] * dHigh;
            }
        }
    }
}

