/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IDispenseHandler;
import cpw.mods.fml.common.IDispenserHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.BlockTracker;
import cpw.mods.fml.common.registry.GameData;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;

public class GameRegistry {
    private static Multimap<ModContainer, BlockProxy> blockRegistry = ArrayListMultimap.create();
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ICraftingHandler> craftingHandlers = Lists.newArrayList();
    private static List<IPickupNotifier> pickupHandlers = Lists.newArrayList();
    private static List<IPlayerTracker> playerTrackers = Lists.newArrayList();

    public static void registerWorldGenerator(IWorldGenerator generator) {
        worldGenerators.add(generator);
    }

    public static void generateWorld(int chunkX, int chunkZ, yc world, zw chunkGenerator, zw chunkProvider) {
        long worldSeed = world.E();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        for (IWorldGenerator generator : worldGenerators) {
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    @Deprecated
    public static void registerDispenserHandler(IDispenserHandler handler) {
    }

    @Deprecated
    public static void registerDispenserHandler(IDispenseHandler handler) {
    }

    @Deprecated
    public static int tryDispense(yc world, int x2, int y2, int z2, int xVelocity, int zVelocity, ur item, Random random, double entX, double entY, double entZ) {
        return -1;
    }

    public static Object buildBlock(ModContainer container, Class<?> type, Mod.Block annotation) throws Exception {
        Object o2 = type.getConstructor(Integer.TYPE).newInstance(GameRegistry.findSpareBlockId());
        GameRegistry.registerBlock((amq)o2);
        return o2;
    }

    private static int findSpareBlockId() {
        return BlockTracker.nextBlockId();
    }

    public static void registerItem(up item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerItem(up item, String name, String modId) {
        GameData.setName(item, name, modId);
    }

    @Deprecated
    public static void registerBlock(amq block) {
        GameRegistry.registerBlock(block, vq.class);
    }

    public static void registerBlock(amq block, String name) {
        GameRegistry.registerBlock(block, vq.class, name);
    }

    @Deprecated
    public static void registerBlock(amq block, Class<? extends vq> itemclass) {
        GameRegistry.registerBlock(block, itemclass, null);
    }

    public static void registerBlock(amq block, Class<? extends vq> itemclass, String name) {
        GameRegistry.registerBlock(block, itemclass, name, null);
    }

    public static void registerBlock(amq block, Class<? extends vq> itemclass, String name, String modId) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            assert (itemclass != null) : "registerBlock: itemclass cannot be null";
            int blockItemId = block.cm - 256;
            up i2 = itemclass.getConstructor(Integer.TYPE).newInstance(blockItemId);
            GameRegistry.registerItem(i2, name, modId);
        }
        catch (Exception e2) {
            FMLLog.log(Level.SEVERE, e2, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e2);
        }
        blockRegistry.put((Object)Loader.instance().activeModContainer(), (Object)((BlockProxy)((Object)block)));
    }

    public static void addRecipe(ur output, Object ... params) {
        wn.a().a(output, params);
    }

    public static void addShapelessRecipe(ur output, Object ... params) {
        wn.a().b(output, params);
    }

    public static void addRecipe(wp recipe) {
        wn.a().b().add(recipe);
    }

    public static void addSmelting(int input, ur output, float xp2) {
        wj.a().a(input, output, xp2);
    }

    public static void registerTileEntity(Class<? extends any> tileEntityClass, String id) {
        any.a(tileEntityClass, id);
    }

    public static void addBiome(yy biome) {
        yn.b.addNewBiome(biome);
    }

    public static void removeBiome(yy biome) {
        yn.b.removeBiome(biome);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(ur itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        craftingHandlers.add(handler);
    }

    public static void onItemCrafted(qx player, ur item, la craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onCrafting(player, item, craftMatrix);
        }
    }

    public static void onItemSmelted(qx player, ur item) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onSmelting(player, item);
        }
    }

    public static void registerPickupHandler(IPickupNotifier handler) {
        pickupHandlers.add(handler);
    }

    public static void onPickupNotification(qx player, px item) {
        for (IPickupNotifier notify : pickupHandlers) {
            notify.notifyPickup(item, player);
        }
    }

    public static void registerPlayerTracker(IPlayerTracker tracker) {
        playerTrackers.add(tracker);
    }

    public static void onPlayerLogin(qx player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogin(player);
        }
    }

    public static void onPlayerLogout(qx player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogout(player);
        }
    }

    public static void onPlayerChangedDimension(qx player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerChangedDimension(player);
        }
    }

    public static void onPlayerRespawn(qx player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerRespawn(player);
        }
    }
}

