/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

public class LiquidStack {
    public int itemID;
    public int amount;
    public int itemMeta;

    private LiquidStack() {
    }

    public LiquidStack(int itemID, int amount) {
        this(itemID, amount, 0);
    }

    public LiquidStack(up item, int amount) {
        this(item.cj, amount, 0);
    }

    public LiquidStack(amq block, int amount) {
        this(block.cm, amount, 0);
    }

    public LiquidStack(int itemID, int amount, int itemDamage) {
        this.itemID = itemID;
        this.amount = amount;
        this.itemMeta = itemDamage;
    }

    public bq writeToNBT(bq nbt) {
        nbt.a("Id", (short)this.itemID);
        nbt.a("Amount", this.amount);
        nbt.a("Meta", (short)this.itemMeta);
        return nbt;
    }

    public void readFromNBT(bq nbt) {
        this.itemID = nbt.d("Id");
        this.amount = nbt.e("Amount");
        this.itemMeta = nbt.d("Meta");
    }

    public LiquidStack copy() {
        return new LiquidStack(this.itemID, this.amount, this.itemMeta);
    }

    public boolean isLiquidEqual(LiquidStack other) {
        return other != null && this.itemID == other.itemID && this.itemMeta == other.itemMeta;
    }

    public boolean containsLiquid(LiquidStack other) {
        return this.isLiquidEqual(other) && this.amount >= other.amount;
    }

    public boolean isLiquidEqual(ur other) {
        return other != null && this.itemID == other.c && this.itemMeta == other.j();
    }

    public ur asItemStack() {
        return new ur(this.itemID, 1, this.itemMeta);
    }

    public static LiquidStack loadLiquidStackFromNBT(bq nbt) {
        LiquidStack liquidstack = new LiquidStack();
        liquidstack.readFromNBT(nbt);
        return liquidstack.itemID == 0 ? null : liquidstack;
    }
}

