/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.featurehack.GameDataManipulator;
import codechicken.nei.EnchantmentInputHandler;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEICompatibility;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightIdentifier;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import codechicken.nei.recipe.weakDependancy_Forge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraftforge.common.IShearable;

public class ItemInfo {
    public static final HashMap fallbackNames = new HashMap();
    public static final HashSet excludeIds = new HashSet();
    public static final HashSet nonUnlimitedIds = new HashSet();
    public static final HashMap damageVariants = new HashMap();
    public static final ArrayList defaultDamageRange = new ArrayList();
    public static final HashMap itemcompounds = new HashMap();
    public static final LinkedList infiniteHandlers = new LinkedList();
    public static final HashMap highlightIdentifiers = new HashMap();
    public static final HashSet fastTransferExemptions = new HashSet();

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList getItemDamageVariants(int itemID) {
        ArrayList damages = (ArrayList)damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemHash itemhash = new ItemHash(itemID, itemDamage);
        return (String)fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList getItemCompounds(int itemID) {
        return (ArrayList)itemcompounds.get(itemID);
    }

    public static void load(yc world) {
        int[] nArray = new int[2];
        nArray[1] = 15;
        defaultDamageRange.add(nArray);
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.addMobSpawnerItem(world);
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new EnchantmentInputHandler());
    }

    private static void addMobSpawnerItem(final yc world) {
        up.e[amq.av.cm] = null;
        GameDataManipulator.createHiddenItem((Runnable)new Runnable(){

            @Override
            public void run() {
                new ItemMobSpawner(world);
            }
        });
        if (NEICompatibility.hasForge) {
            weakDependancy_Forge.addMobSpawnerRenderer();
        }
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(amq.D.cm, 0, "Water Source");
        API.setMaxDamageException(amq.D.cm, 0);
        API.setOverrideName(amq.E.cm, 0, "Water Still");
        API.setMaxDamageException(amq.E.cm, 0);
        API.setOverrideName(amq.F.cm, 0, "Lava Source");
        API.setMaxDamageException(amq.F.cm, 0);
        API.setOverrideName(amq.G.cm, 0, "Lava Still");
        API.setMaxDamageException(amq.G.cm, 0);
        API.setOverrideName(amq.bo.cm, 0, "Silverfish Stone");
        API.setOverrideName(amq.bK.cm, 0, "End Portal");
        API.setOverrideName(amq.bL.cm, 0, "End Portal Frame");
        API.hideItem(amq.ad.cm);
        API.hideItem(amq.af.cm);
        API.hideItem(amq.bw.cm);
        API.hideItem(amq.bv.cm);
        API.hideItem(amq.V.cm);
        API.hideItem(amq.ay.cm);
        API.hideItem(amq.aC.cm);
        API.hideItem(amq.aG.cm);
        API.hideItem(amq.aH.cm);
        API.hideItem(amq.aL.cm);
        API.hideItem(amq.aO.cm);
        API.hideItem(amq.aR.cm);
        API.hideItem(amq.aS.cm);
        API.hideItem(amq.ba.cm);
        API.hideItem(amq.bk.cm);
        API.hideItem(amq.bl.cm);
        API.hideItem(amq.bJ.cm);
        API.hideItem(amq.bG.cm);
        API.hideItem(amq.bI.cm);
        API.hideItem(amq.aF.cm);
        API.hideItem(amq.bP.cm);
        API.hideItem(amq.cf.cm);
        API.hideItem(amq.cg.cm);
        API.hideItem(amq.ch.cm);
        API.hideItem(amq.cj.cm);
        API.hideItem(amq.bX.cm);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, bq compound) {
                if (item < amq.p.length && amq.p[item] != null && amq.p[item].cB != agi.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, bq compound) {
                if (item >= amq.p.length || amq.p[item] == null || amq.p[item].cB == agi.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Vanilla.Blocks", new MultiItemRange("[1-145]"));
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
        API.addSetRange("Vanilla.Items", new MultiItemRange("[256-400],[2256-2267]"));
    }

    private static void searchItems() {
        tj tab;
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        MultiItemRange[] creativeTabRanges = new MultiItemRange[tj.a.length];
        tj[] tjArray = tj.a;
        int n = tj.a.length;
        int n2 = 0;
        while (n2 < n) {
            tab = tjArray[n2];
            creativeTabRanges[tab.a()] = new MultiItemRange();
            ++n2;
        }
        tjArray = up.e;
        n = up.e.length;
        n2 = 0;
        while (n2 < n) {
            tj item = tjArray[n2];
            if (item != null) {
                tj itemTab = item.w();
                if (itemTab != null) {
                    creativeTabRanges[itemTab.a()].add((up)item);
                }
                if (item.n()) {
                    tools.add((up)item);
                    if (item instanceof uy) {
                        picks.add((up)item);
                    } else if (item instanceof vj) {
                        shovels.add((up)item);
                    } else if (item instanceof un) {
                        axes.add((up)item);
                    } else if (item instanceof uo) {
                        hoes.add((up)item);
                    } else if (item instanceof vu) {
                        swords.add((up)item);
                    } else if (item instanceof su) {
                        switch (((su)item).a) {
                            case 0: {
                                helmets.add((up)item);
                                break;
                            }
                            case 1: {
                                chest.add((up)item);
                                break;
                            }
                            case 2: {
                                legs.add((up)item);
                                break;
                            }
                            case 3: {
                                boots.add((up)item);
                            }
                        }
                    } else if (item == up.l || item == up.k) {
                        ranged.add((up)item);
                    } else if (item == up.aR || item == up.i || item == up.be) {
                        other.add((up)item);
                    }
                }
                if (item instanceof uk) {
                    food.add((up)item);
                }
                if (item.v()) {
                    BrewingRecipeHandler.ingredientIDs.add(item.cj);
                    potioningredients.add((up)item);
                }
            }
            ++n2;
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
        tjArray = tj.a;
        n = tj.a.length;
        n2 = 0;
        while (n2 < n) {
            tab = tjArray[n2];
            if (creativeTabRanges[tab.a()].ranges.size() > 0) {
                API.addSetRange("CreativeTabs." + tab.c(), creativeTabRanges[tab.a()]);
            }
            ++n2;
        }
    }

    private static void addSpawnEggs() {
        ArrayList<Integer> damages = new ArrayList<Integer>();
        try {
            HashMap classToIDMapping = (HashMap)lv.e;
            damages.add((Integer)classToIDMapping.get(pb.class));
            damages.add((Integer)classToIDMapping.get(qn.class));
            damages.add((Integer)classToIDMapping.get(qc.class));
            damages.add((Integer)classToIDMapping.get(qo.class));
            damages.add((Integer)classToIDMapping.get(qr.class));
            damages.add((Integer)classToIDMapping.get(qp.class));
            damages.add((Integer)classToIDMapping.get(oy.class));
            damages.add((Integer)classToIDMapping.get(qb.class));
            damages.add((Integer)classToIDMapping.get(oz.class));
            damages.add((Integer)classToIDMapping.get(qd.class));
            damages.add((Integer)classToIDMapping.get(pk.class));
            damages.add((Integer)classToIDMapping.get(qk.class));
            damages.add((Integer)classToIDMapping.get(ph.class));
            damages.add((Integer)classToIDMapping.get(qg.class));
            damages.add((Integer)classToIDMapping.get(qi.class));
            damages.add((Integer)classToIDMapping.get(pe.class));
            damages.add((Integer)classToIDMapping.get(qa.class));
            damages.add((Integer)classToIDMapping.get(qu.class));
            damages.add((Integer)classToIDMapping.get(qm.class));
            damages.add((Integer)classToIDMapping.get(pd.class));
            damages.add((Integer)classToIDMapping.get(pc.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(pg.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(pi.class), 12960449, 16769484);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        API.setItemDamageVariants(up.bC.cj, damages);
    }

    private static void addEntityEgg(ArrayList damages, Integer ID, int i, int j) {
        damages.add(ID);
        lv.a.put(ID, new lw(ID.intValue(), i, j));
    }

    public static ArrayList getIdentifierItems(yc world, qx player, aoh hit) {
        IShearable shearable;
        int x = hit.b;
        int y = hit.c;
        int z = hit.d;
        amq mouseoverBlock = amq.p[world.a(x, y, z)];
        ArrayList<ur> items = new ArrayList<ur>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.get(0) != null) {
            handlers.addAll((Collection)highlightIdentifiers.get(0));
        }
        if (highlightIdentifiers.get(mouseoverBlock.cm) != null) {
            handlers.addAll((Collection)highlightIdentifiers.get(mouseoverBlock.cm));
        }
        for (IHighlightIdentifier ident : handlers) {
            ur item = ident.identifyHighlight(world, player, x, y, z, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        ur pick = mouseoverBlock.getPickBlock(hit, world, x, y, z);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(mouseoverBlock.getBlockDropped(world, x, y, z, world.h(x, y, z), 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ur((up)up.be), world, x, y, z)) {
            items.addAll(shearable.onSheared(new ur((up)up.be), world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ur(mouseoverBlock, 1, world.h(x, y, z)));
        }
        return items;
    }
}

