/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.FastTransferManger;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultOverlayHandler
implements IOverlayHandler {
    int offsetx;
    int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(avf gui, List ingredients, boolean shift) {
        List ingredStacks = this.getPermutationIngredients(ingredients);
        this.findInventoryQuantities(gui, ingredStacks);
        List assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private void moveIngredients(avf gui, List assignedIngredients, int quantity) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            ur pstack = distrib.permutation;
            int transferCap = quantity * pstack.a;
            int transferred = 0;
            int destSlotIndex = 0;
            sr dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.d();
            for (sr slot : gui.d.c) {
                ur stack;
                if (!slot.d() || !(slot.f instanceof qw) || !InventoryUtils.canStack((ur)(stack = slot.c()), (ur)pstack)) continue;
                FastTransferManger.clickSlot(gui, slot.g);
                int amount = Math.min(transferCap - transferred, stack.a);
                int c = 0;
                while (c < amount) {
                    FastTransferManger.clickSlot(gui, dest.g, 1);
                    ++transferred;
                    if (++slotTransferred >= slotTransferCap) {
                        if (++destSlotIndex == distrib.slots.length) {
                            dest = null;
                            break;
                        }
                        dest = distrib.slots[destSlotIndex];
                        slotTransferred = 0;
                    }
                    ++c;
                }
                FastTransferManger.clickSlot(gui, slot.g);
                if (transferred >= transferCap || dest == null) continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.d()) {
                allSlots = istack.numSlots * istack.stack.d();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private sr[][] assignIngredSlots(avf gui, List ingredients, List assignedIngredients) {
        sr[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<sr, Integer> distribution = new HashMap<sr, Integer>();
        int i = 0;
        while (i < recipeSlots.length) {
            sr[] srArray = recipeSlots[i];
            int n = srArray.length;
            int n2 = 0;
            while (n2 < n) {
                sr slot = srArray[n2];
                if (!distribution.containsKey(slot)) {
                    distribution.put(slot, -1);
                }
                ++n2;
            }
            ++i;
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        int i2 = 0;
        while (i2 < ingredients.size()) {
            remainingIngreds.add(i2);
            assignedSlots.add(new LinkedList());
            ++i2;
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i3 = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = ((IngredientDistribution)assignedIngredients.get((int)i3)).distrib;
                sr[] srArray = recipeSlots[i3];
                int n = srArray.length;
                int n3 = 0;
                while (n3 < n) {
                    sr slot = srArray[n3];
                    if (avaliableSlots.contains(slot)) {
                        avaliableSlots.remove(slot);
                        if (!slot.d()) {
                            ++istack.numSlots;
                            ((LinkedList)assignedSlots.get(i3)).add(slot);
                            assigned = true;
                            break;
                        }
                    }
                    ++n3;
                }
                if (assigned && istack.numSlots * istack.stack.d() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        i = 0;
        while (i < ingredients.size()) {
            ((IngredientDistribution)assignedIngredients.get((int)i)).slots = ((LinkedList)assignedSlots.get(i)).toArray(new sr[0]);
            ++i;
        }
        return recipeSlots;
    }

    private List assignIngredients(List ingredients, List ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ur permutation = null;
            int biggestSize = 0;
            ur[] urArray = posstack.items;
            int n = posstack.items.length;
            int n2 = 0;
            while (n2 < n) {
                ur pstack = urArray[n2];
                int j = 0;
                while (j < ingredStacks.size()) {
                    int relsize;
                    DistributedIngred istack = (DistributedIngred)ingredStacks.get(j);
                    if (InventoryUtils.canStack((ur)pstack, (ur)istack.stack) && istack.invAmount - istack.distributed >= pstack.a && (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.a) > biggestSize) {
                        biggestSize = relsize;
                        biggestIngred = istack;
                        permutation = pstack;
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.a;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(avf gui, List ingredStacks) {
        for (sr slot : gui.d.c) {
            ur pstack;
            DistributedIngred istack;
            if (!slot.d() || !(slot.f instanceof qw) || (istack = this.findIngred(ingredStacks, pstack = slot.c())) == null) continue;
            istack.invAmount += pstack.a;
        }
    }

    private List getPermutationIngredients(List ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            ur[] urArray = posstack.items;
            int n = posstack.items.length;
            int n2 = 0;
            while (n2 < n) {
                ur pstack = urArray[n2];
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.a;
                ++n2;
            }
        }
        return ingredStacks;
    }

    public sr[][] mapIngredSlots(avf gui, List ingredients) {
        sr[][] recipeSlotList = new sr[ingredients.size()][];
        int i = 0;
        while (i < ingredients.size()) {
            LinkedList<sr> recipeSlots = new LinkedList<sr>();
            PositionedStack pstack = (PositionedStack)ingredients.get(i);
            for (sr slot : gui.d.c) {
                if (slot.h != pstack.relx + this.offsetx || slot.i != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new sr[0]);
            ++i;
        }
        return recipeSlotList;
    }

    public void clickSlot(avf window, int slotIndex, int button, int modifier) {
        rq container = window.d;
        sr slot = null;
        if (slotIndex >= 0 && slotIndex < container.c.size()) {
            slot = container.a(slotIndex);
        }
        window.a(slot, slotIndex, button, modifier);
    }

    public DistributedIngred findIngred(List ingredStacks, ur pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!InventoryUtils.canStack((ur)pstack, (ur)istack.stack)) continue;
            return istack;
        }
        return null;
    }

    public static class DistributedIngred {
        public ur stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(ur item) {
            this.stack = InventoryUtils.copyStack((ur)item, (int)1);
        }
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ur permutation;
        public sr[] slots;

        public IngredientDistribution(DistributedIngred distrib, ur permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }
}

