/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.BrewingOverlayHandler;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import com.google.common.base.Objects;
import java.util.HashMap;

public class RecipeInfo {
    static HashMap overlayMap = new HashMap();
    static HashMap positionerMap = new HashMap();

    public static void registerOverlayHandler(Class classz, IOverlayHandler handler, String ident) {
        overlayMap.put(new OverlayKey(classz, ident), handler);
    }

    public static void registerGuiOverlay(Class classz, String ident, IStackPositioner positioner) {
        positionerMap.put(new OverlayKey(classz, ident), positioner);
    }

    public static boolean hasDefaultOverlay(avf gui, String ident) {
        return positionerMap.containsKey(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static boolean hasOverlayHandler(avf gui, String ident) {
        return overlayMap.containsKey(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static IOverlayHandler getOverlayHandler(avf gui, String ident) {
        return (IOverlayHandler)overlayMap.get(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static IStackPositioner getStackPositioner(avf gui, String ident) {
        return (IStackPositioner)positionerMap.get(new OverlayKey(((Object)((Object)gui)).getClass(), ident));
    }

    public static void load() {
        API.registerRecipeHandler(new ShapedRecipeHandler());
        API.registerUsageHandler(new ShapedRecipeHandler());
        API.registerRecipeHandler(new ShapelessRecipeHandler());
        API.registerUsageHandler(new ShapelessRecipeHandler());
        API.registerRecipeHandler(new FurnaceRecipeHandler());
        API.registerUsageHandler(new FurnaceRecipeHandler());
        API.registerRecipeHandler(new BrewingRecipeHandler());
        API.registerUsageHandler(new BrewingRecipeHandler());
        API.registerRecipeHandler(new FuelRecipeHandler());
        API.registerUsageHandler(new FuelRecipeHandler());
        API.registerGuiOverlay(avq.class, "crafting");
        API.registerGuiOverlay(avz.class, "crafting2x2", 63, 20);
        API.registerGuiOverlay(avy.class, "smelting");
        API.registerGuiOverlay(avy.class, "fuel");
        API.registerGuiOverlay(avn.class, "brewing");
        API.registerGuiOverlayHandler(avq.class, new DefaultOverlayHandler(), "crafting");
        API.registerGuiOverlayHandler(avn.class, new BrewingOverlayHandler(), "brewing");
    }

    private static class OverlayKey {
        String ident;
        Class guiClass;

        public OverlayKey(Class classz, String ident) {
            this.guiClass = classz;
            this.ident = ident;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverlayKey)) {
                return false;
            }
            OverlayKey key = (OverlayKey)obj;
            return this.ident.equals(key.ident) && this.guiClass == key.guiClass;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ident, this.guiClass});
        }
    }

    private static class OverlayValue {
        IOverlayHandler handler;
        int mode;

        public OverlayValue(IOverlayHandler handler, int mode) {
            this.handler = handler;
            this.mode = mode;
        }
    }
}

