package atomicstryker.minefactoryreloaded.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import atomicstryker.minefactoryreloaded.common.MineFactoryReloadedCore;
import atomicstryker.minefactoryreloaded.common.core.Util;

public class BlockRailCargoPickup extends BlockRail
{
	public BlockRailCargoPickup(int i, int j)
	{
		super(i, j, true);
		setBlockName("cargoPickupRail");
		setHardness(0.5F);
		setStepSound(Block.soundMetalFootstep);
	}

	@Override
	public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity)
	{
		if(world.isRemote || !(entity instanceof EntityMinecart))
		{
			return;
		}
		EntityMinecart minecart = (EntityMinecart)entity;
		if(minecart.minecartType != 1)
		{
			return;
		}
		
		for(IInventory chest : Util.findChests(world, x, y, z))
		{
			for(int slotIndex = 0; slotIndex < chest.getSizeInventory(); slotIndex++)
			{
				ItemStack sourceStack = chest.getStackInSlot(slotIndex);
				if(sourceStack == null)
				{
					continue;
				}
				ItemStack stackToAdd = sourceStack.copy();
				int amountRemaining = Util.addToInventory(minecart, stackToAdd);
				if(amountRemaining == 0)
				{
					chest.setInventorySlotContents(slotIndex, null);
				}
				else
				{
					sourceStack.stackSize = amountRemaining;
					break;
				}
			}
		}
	}

	@Override
	public String getTextureFile()
	{
        return MineFactoryReloadedCore.terrainTexture;
	}

}
