package atomicstryker.minefactoryreloaded.common.farmables;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import atomicstryker.minefactoryreloaded.common.api.IFactoryFertilizable;

public class FertilizableSapling implements IFactoryFertilizable
{	
	@Override
	public int getFertilizableBlockId()
	{
		return Block.sapling.blockID;
	}

	@Override
	public boolean canFertilizeBlock(World world, int x, int y, int z, ItemStack fertilizer)
	{
		return fertilizer.itemID == Item.dyePowder.shiftedIndex && fertilizer.getItemDamage() == 15;
	}

	@Override
	public boolean fertilize(World world, int x, int y, int z, ItemStack fertilizer)
	{
		((BlockSapling)Block.sapling).growTree(world, x, y, z, world.rand);
        return world.getBlockId(x, y, z) != Block.sapling.blockID;
	}
}
