package atomicstryker.minefactoryreloaded.common.farmables;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import atomicstryker.minefactoryreloaded.common.MineFactoryReloadedCore;
import atomicstryker.minefactoryreloaded.common.api.IFactoryFertilizable;

public class FertilizableStemPlants implements IFactoryFertilizable
{
	private int fertilizableId;
	
	public FertilizableStemPlants(int fertilizableId)
	{
		this.fertilizableId = fertilizableId;
	}

	@Override
	public int getFertilizableBlockId()
	{
		return fertilizableId;
	}

	@Override
	public boolean canFertilizeBlock(World world, int x, int y, int z, ItemStack fertilizer)
	{
		return fertilizer.itemID == Item.dyePowder.shiftedIndex && fertilizer.getItemDamage() == 15 &&
			world.getBlockMetadata(x, y, z) < 7;
	}

	@Override
	public boolean fertilize(World world, int x, int y, int z, ItemStack fertilizer)
	{
		MineFactoryReloadedCore.instance().fertilizeStemPlant(world, x, y, z);
		return world.getBlockMetadata(x, y, z) == 7;
	}

}
