package atomicstryker.minefactoryreloaded.common.farmables;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.world.World;
import atomicstryker.minefactoryreloaded.common.api.HarvestType;
import atomicstryker.minefactoryreloaded.common.api.IFactoryHarvestable;

public class HarvestableWood extends HarvestableStandard implements IFactoryHarvestable
{
	public HarvestableWood()
	{
		super(Block.wood.blockID, HarvestType.Tree);
	}
	
	@Override
	public boolean canBeHarvested(World world, int x, int y, int z)
	{
		return BlockLog.limitToValidMetadata(world.getBlockMetadata(x, y, z)) != 3;
	}
}
