/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.VirtualFlowHelper;
import com.jfoenix.adapters.skins.ListViewSkin;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.effects.JFXDepthManager;
import javafx.application.Platform;
import javafx.scene.control.ListView;

public class JFXListViewSkin<T>
extends ListViewSkin<T> {
    public JFXListViewSkin(JFXListView<T> listView) {
        super(listView);
        JFXDepthManager.setDepth(this.getFlow(), (Integer)listView.depthProperty().get());
        listView.depthProperty().addListener((o, oldVal, newVal) -> JFXDepthManager.setDepth(this.getFlow(), newVal));
        listView.getItems().addListener(change -> new Thread(() -> {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException intEx) {
                intEx.printStackTrace();
            }
            Platform.runLater(() -> ((ListView)this.getSkinnable()).requestLayout());
        }).start());
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ListView)this.getSkinnable()).maxHeightProperty().isBound() || ((ListView)this.getSkinnable()).getItems().size() <= 0) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        if (((ListView)this.getSkinnable()).getMaxHeight() > 0.0) {
            return ((ListView)this.getSkinnable()).getMaxHeight();
        }
        double computedHeight = this.estimateHeight();
        double height = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        if (height > computedHeight) {
            height = computedHeight;
        }
        return height;
    }

    private double estimateHeight() {
        double borderWidth = ((ListView)this.getSkinnable()).snappedBottomInset() + ((ListView)this.getSkinnable()).snappedTopInset();
        JFXListView listview = (JFXListView)this.getSkinnable();
        double gap = listview.isExpanded() != false ? ((JFXListView)this.getSkinnable()).getVerticalGap() * (double)((ListView)this.getSkinnable()).getItems().size() : 0.0;
        double cellsHeight = VirtualFlowHelper.forEach(this.getFlow(), 0.0, (cell, h) -> 1.0 + h + cell.getHeight());
        return cellsHeight + gap + borderWidth;
    }
}

