/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactInfo;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilSession;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.function.ExceptionalSupplier;

public class AuthlibInjectorAccount
extends YggdrasilAccount {
    private final AuthlibInjectorServer server;
    private AuthlibInjectorArtifactProvider downloader;

    public AuthlibInjectorAccount(AuthlibInjectorServer server, AuthlibInjectorArtifactProvider downloader, String username, String password, CharacterSelector selector) throws AuthenticationException {
        super(server.getYggdrasilService(), username, password, selector);
        this.server = server;
        this.downloader = downloader;
    }

    public AuthlibInjectorAccount(AuthlibInjectorServer server, AuthlibInjectorArtifactProvider downloader, String username, YggdrasilSession session) {
        super(server.getYggdrasilService(), username, session);
        this.server = server;
        this.downloader = downloader;
    }

    @Override
    public synchronized AuthInfo logIn() throws AuthenticationException {
        return this.inject(() -> super.logIn());
    }

    @Override
    public synchronized AuthInfo logInWithPassword(String password) throws AuthenticationException {
        return this.inject(() -> super.logInWithPassword(password));
    }

    @Override
    public Optional<AuthInfo> playOffline() {
        Optional<AuthInfo> auth = super.playOffline();
        Optional<AuthlibInjectorArtifactInfo> artifact = this.downloader.getArtifactInfoImmediately();
        Optional<String> prefetchedMeta = this.server.getMetadataResponse();
        if (auth.isPresent() && artifact.isPresent() && prefetchedMeta.isPresent()) {
            return Optional.of(auth.get().withArguments(AuthlibInjectorAccount.generateArguments(artifact.get(), this.server, prefetchedMeta.get())));
        }
        return Optional.empty();
    }

    private AuthInfo inject(ExceptionalSupplier<AuthInfo, AuthenticationException> loginAction) throws AuthenticationException {
        AuthlibInjectorArtifactInfo artifact;
        String prefetchedMeta;
        CompletableFuture<String> prefetchedMetaTask = CompletableFuture.supplyAsync(() -> {
            try {
                return this.server.fetchMetadataResponse();
            }
            catch (IOException e) {
                throw new CompletionException(new ServerDisconnectException(e));
            }
        });
        CompletableFuture<AuthlibInjectorArtifactInfo> artifactTask = CompletableFuture.supplyAsync(() -> {
            try {
                return this.downloader.getArtifactInfo();
            }
            catch (IOException e) {
                throw new CompletionException(new AuthlibInjectorDownloadException(e));
            }
        });
        AuthInfo auth = loginAction.get();
        try {
            prefetchedMeta = prefetchedMetaTask.get();
            artifact = artifactTask.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AuthenticationException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AuthenticationException) {
                throw (AuthenticationException)e.getCause();
            }
            throw new AuthenticationException(e.getCause());
        }
        return auth.withArguments(AuthlibInjectorAccount.generateArguments(artifact, this.server, prefetchedMeta));
    }

    private static Arguments generateArguments(AuthlibInjectorArtifactInfo artifact, AuthlibInjectorServer server, String prefetchedMeta) {
        return new Arguments().addJVMArguments("-javaagent:" + artifact.getLocation().toString() + "=" + server.getUrl(), "-Dauthlibinjector.side=client", "-Dauthlibinjector.yggdrasil.prefetched=" + Base64.getEncoder().encodeToString(prefetchedMeta.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Map<Object, Object> toStorage() {
        Map<Object, Object> map = super.toStorage();
        map.put("serverBaseURL", this.server.getUrl());
        return map;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.server.invalidateMetadataCache();
    }

    public AuthlibInjectorServer getServer() {
        return this.server;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.server.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != AuthlibInjectorAccount.class) {
            return false;
        }
        AuthlibInjectorAccount another = (AuthlibInjectorAccount)obj;
        return this.characterUUID.equals(another.characterUUID) && this.server.equals(another.server);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("uuid", this.characterUUID).append("username", this.getUsername()).append("server", this.getServer().getUrl()).toString();
    }

    public static Set<TextureType> getUploadableTextures(CompleteGameProfile profile) {
        String prop = profile.getProperties().get("uploadableTextures");
        if (prop == null) {
            return Collections.emptySet();
        }
        EnumSet<TextureType> result = EnumSet.noneOf(TextureType.class);
        for (String val : prop.split(",")) {
            TextureType parsed;
            val = val.toUpperCase();
            try {
                parsed = TextureType.valueOf(val);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            result.add(parsed);
        }
        return Collections.unmodifiableSet(result);
    }
}

