/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.game.LibraryDownloadTask;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LibraryDownloadInfo;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.NotNull;

public class DefaultCacheRepository
extends CacheRepository {
    private Path librariesDir;
    private Path indexFile;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Index index = null;

    public DefaultCacheRepository() {
        this(OperatingSystem.getWorkingDirectory("minecraft"));
    }

    public DefaultCacheRepository(Path commonDirectory) {
        this.changeDirectory(commonDirectory);
    }

    @Override
    public void changeDirectory(Path commonDir) {
        super.changeDirectory(commonDir);
        this.librariesDir = commonDir.resolve("libraries");
        this.indexFile = this.getCacheDirectory().resolve("index.json");
        this.lock.writeLock().lock();
        try {
            this.index = Files.isRegularFile(this.indexFile, new LinkOption[0]) ? JsonUtils.fromNonNullJson(FileUtils.readText(this.indexFile.toFile()), Index.class) : new Index();
        }
        catch (JsonParseException | IOException e) {
            Logging.LOG.log(Level.WARNING, "Unable to read index file", e);
            this.index = new Index();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void tryCacheLibrary(Library library, Path jar) {
        this.lock.readLock().lock();
        try {
            if (this.index.getLibraries().stream().anyMatch(it -> library.getName().equals(it.getName()))) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            LibraryDownloadInfo info = library.getDownload();
            String hash = info.getSha1();
            if (hash != null) {
                String checksum = Hex.encodeHex(DigestUtils.digest("SHA-1", jar));
                if (hash.equalsIgnoreCase(checksum)) {
                    this.cacheLibrary(library, jar, false);
                }
            } else if (library.getChecksums() != null && !library.getChecksums().isEmpty() && LibraryDownloadTask.checksumValid(jar.toFile(), library.getChecksums())) {
                this.cacheLibrary(library, jar, true);
            }
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Unable to calc hash value of file " + jar, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Path> getLibrary(Library library) {
        block14: {
            LibraryDownloadInfo info = library.getDownload();
            String hash = info.getSha1();
            if (this.fileExists("SHA-1", hash)) {
                return Optional.of(this.getFile("SHA-1", hash));
            }
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                List libraries = this.index.getLibraries().stream().filter(it -> it.getName().equals(library.getName())).collect(Collectors.toList());
                for (LibraryIndex libIndex : libraries) {
                    if (!this.fileExists("SHA-1", libIndex.getHash())) continue;
                    Path file = this.getFile("SHA-1", libIndex.getHash());
                    if (!libIndex.getType().equalsIgnoreCase("forge") || !LibraryDownloadTask.checksumValid(file.toFile(), library.getChecksums())) continue;
                    Optional<Path> optional = Optional.of(file);
                    return optional;
                }
            }
            finally {
                readLock.unlock();
            }
            Path jar = this.librariesDir.resolve(info.getPath());
            if (Files.exists(jar, new LinkOption[0])) {
                try {
                    if (hash != null) {
                        String checksum = Hex.encodeHex(DigestUtils.digest("SHA-1", jar));
                        if (hash.equalsIgnoreCase(checksum)) {
                            return Optional.of(this.restore(jar, () -> this.cacheLibrary(library, jar, false)));
                        }
                        break block14;
                    }
                    if (library.getChecksums() != null && !library.getChecksums().isEmpty()) {
                        if (LibraryDownloadTask.checksumValid(jar.toFile(), library.getChecksums())) {
                            return Optional.of(this.restore(jar, () -> this.cacheLibrary(library, jar, true)));
                        }
                        break block14;
                    }
                    return Optional.of(jar);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path cacheLibrary(Library library, Path path, boolean forge) throws IOException {
        String hash = library.getDownload().getSha1();
        if (hash == null) {
            hash = Hex.encodeHex(DigestUtils.digest("SHA-1", path));
        }
        Path cache = this.getFile("SHA-1", hash);
        FileUtils.copyFile(path.toFile(), cache.toFile());
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            LibraryIndex libIndex = new LibraryIndex(library.getName(), hash, forge ? "forge" : "jar");
            this.index.getLibraries().add(libIndex);
            this.saveIndex();
        }
        finally {
            writeLock.unlock();
        }
        return cache;
    }

    private void saveIndex() {
        if (this.indexFile == null || this.index == null) {
            return;
        }
        try {
            FileUtils.writeText(this.indexFile.toFile(), JsonUtils.GSON.toJson(this.index));
        }
        catch (IOException e) {
            Logging.LOG.log(Level.SEVERE, "Unable to save index.json", e);
        }
    }

    private class Index
    implements Validation {
        private final Set<LibraryIndex> libraries;

        public Index() {
            this(new HashSet<LibraryIndex>());
        }

        public Index(Set<LibraryIndex> libraries) {
            this.libraries = Objects.requireNonNull(libraries);
        }

        @NotNull
        public Set<LibraryIndex> getLibraries() {
            return this.libraries;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            if (this.libraries == null) {
                throw new JsonParseException("Index.libraries cannot be null");
            }
        }
    }

    private class LibraryIndex
    implements Validation {
        private final String name;
        private final String hash;
        private final String type;
        public static final String TYPE_FORGE = "forge";
        public static final String TYPE_JAR = "jar";

        public LibraryIndex() {
            this("", "", "");
        }

        public LibraryIndex(String name, String hash, String type) {
            this.name = name;
            this.hash = hash;
            this.type = type;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getHash() {
            return this.hash;
        }

        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            if (this.name == null || this.hash == null || this.type == null) {
                throw new JsonParseException("Index.LibraryIndex.* cannot be null");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LibraryIndex that = (LibraryIndex)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.hash, that.hash) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.hash, this.type);
        }
    }
}

