/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.VersionLibraryBuilder;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.SimpleMultimap;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class MaintainTask
extends Task<Version> {
    private final GameRepository repository;
    private final Version version;

    public MaintainTask(GameRepository repository, Version version) {
        this.repository = repository;
        this.version = version;
        if (version.getInheritsFrom() != null) {
            throw new IllegalArgumentException("MaintainTask requires independent game version");
        }
    }

    @Override
    public void execute() {
        this.setResult(MaintainTask.maintain(this.repository, this.version));
    }

    public static Version maintain(GameRepository repository, Version version) {
        if (version.getInheritsFrom() != null) {
            throw new IllegalArgumentException("MaintainTask requires independent game version");
        }
        String mainClass = version.resolve(null).getMainClass();
        if (mainClass != null && mainClass.equals("net.minecraft.launchwrapper.Launch")) {
            return MaintainTask.maintainOptiFineLibrary(repository, MaintainTask.maintainGameWithLaunchWrapper(MaintainTask.unique(version), true), false);
        }
        if (mainClass != null && mainClass.equals("cpw.mods.modlauncher.Launcher")) {
            return MaintainTask.maintainOptiFineLibrary(repository, MaintainTask.maintainGameWithModLauncher(repository, MaintainTask.unique(version)), true);
        }
        return MaintainTask.maintainOptiFineLibrary(repository, MaintainTask.unique(version), false);
    }

    public static Version maintainPreservingPatches(GameRepository repository, Version version) {
        if (!version.isResolvedPreservingPatches()) {
            throw new IllegalArgumentException("MaintainTask requires independent game version");
        }
        Version newVersion = MaintainTask.maintain(repository, version.resolve(repository));
        return newVersion.setPatches(version.getPatches()).markAsUnresolved();
    }

    private static Version maintainGameWithLaunchWrapper(Version version, boolean reorderTweakClass) {
        LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version);
        VersionLibraryBuilder builder = new VersionLibraryBuilder(version);
        String mainClass = null;
        if (!libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
            builder.removeTweakClass("forge");
        }
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER) && !libraryAnalyzer.hasModLauncher()) {
            builder.replaceTweakClass("liteloader", "com.mumfrey.liteloader.launch.LiteLoaderTweaker", !reorderTweakClass);
        } else {
            builder.removeTweakClass("liteloader");
        }
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
            if (!libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER) && !libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
                builder.replaceTweakClass("optifine", "optifine.OptiFineTweaker", !reorderTweakClass);
            } else if (libraryAnalyzer.hasModLauncher()) {
                mainClass = "cpw.mods.modlauncher.Launcher";
                builder.replaceTweakClass("optifine", "optifine.OptiFineForgeTweaker", !reorderTweakClass);
            } else {
                builder.replaceTweakClass("optifine", "optifine.OptiFineForgeTweaker", !reorderTweakClass);
            }
        } else {
            builder.removeTweakClass("optifine");
        }
        Version ret = builder.build();
        return mainClass == null ? ret : ret.setMainClass(mainClass);
    }

    private static Version maintainGameWithModLauncher(GameRepository repository, Version version) {
        LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version);
        VersionLibraryBuilder builder = new VersionLibraryBuilder(version);
        if (!libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
            return version;
        }
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
            Library hmclTransformerDiscoveryService = new Library(new Artifact("org.jackhuang.hmcl", "transformer-discovery-service", "1.0"));
            Optional<Library> optiFine = version.getLibraries().stream().filter(library -> library.is("optifine", "OptiFine")).findAny();
            boolean libraryExisting = version.getLibraries().stream().anyMatch(library -> library.is("org.jackhuang.hmcl", "transformer-discovery-service"));
            optiFine.ifPresent(library -> {
                builder.addJvmArgument("-Dhmcl.transformer.candidates=${libraries_directory}/" + library.getPath());
                if (!libraryExisting) {
                    builder.addLibrary(hmclTransformerDiscoveryService);
                }
                Path libraryPath = repository.getLibraryFile(version, hmclTransformerDiscoveryService).toPath();
                try {
                    Files.createDirectories(libraryPath.getParent(), new FileAttribute[0]);
                    Files.copy(MaintainTask.class.getResourceAsStream("/assets/game/HMCLTransformerDiscoveryService-1.0.jar"), libraryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Unable to unpack HMCLTransformerDiscoveryService", e);
                }
            });
        }
        return builder.build();
    }

    private static Version maintainOptiFineLibrary(GameRepository repository, Version version, boolean remove) {
        LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version);
        ArrayList<Library> libraries = new ArrayList<Library>(version.getLibraries());
        if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE) && (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER) || libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) && repository != null) {
            for (int i = 0; i < version.getLibraries().size(); ++i) {
                Library newLibrary;
                Library library = (Library)libraries.get(i);
                if (library.is("optifine", "OptiFine") && repository.getLibraryFile(version, newLibrary = new Library(new Artifact("optifine", "OptiFine", library.getVersion(), "installer"))).exists()) {
                    libraries.set(i, null);
                    if (!remove) {
                        libraries.add(newLibrary);
                    }
                }
                if (!library.is("optifine", "launchwrapper-of")) continue;
                libraries.set(i, null);
            }
        }
        return version.setLibraries(libraries.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static boolean isPurePatched(Version version) {
        if (!version.isResolvedPreservingPatches()) {
            throw new IllegalArgumentException("isPurePatched requires a version resolved preserving patches");
        }
        return version.hasPatch("game");
    }

    public static Version unique(Version version) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        SimpleMultimap<String, Integer> multimap = new SimpleMultimap<String, Integer>(HashMap::new, LinkedList::new);
        for (Library library : version.getLibraries()) {
            String id = library.getGroupId() + ":" + library.getArtifactId();
            VersionNumber number = VersionNumber.asVersion(library.getVersion());
            String serialized = JsonUtils.GSON.toJson(library);
            if (multimap.containsKey(id)) {
                boolean duplicate = false;
                Iterator iterator = multimap.get(id).iterator();
                while (iterator.hasNext()) {
                    int otherLibraryIndex = (Integer)iterator.next();
                    Library otherLibrary = (Library)libraries.get(otherLibraryIndex);
                    VersionNumber otherNumber = VersionNumber.asVersion(otherLibrary.getVersion());
                    if (!CompatibilityRule.equals(library.getRules(), otherLibrary.getRules())) continue;
                    boolean flag = true;
                    if (number.compareTo(otherNumber) > 0) {
                        libraries.set(otherLibraryIndex, library);
                    } else if (number.compareTo(otherNumber) == 0) {
                        if (library.equals(otherLibrary)) {
                            String otherSerialized = JsonUtils.GSON.toJson(otherLibrary);
                            if (serialized.length() > otherSerialized.length()) {
                                libraries.set(otherLibraryIndex, library);
                            }
                        } else {
                            flag = false;
                        }
                    }
                    if (!flag) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                multimap.put(id, libraries.size());
                libraries.add(library);
                continue;
            }
            multimap.put(id, libraries.size());
            libraries.add(library);
        }
        return version.setLibraries(libraries);
    }
}

