/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.SimpleMultimap;

public abstract class VersionList<T extends RemoteVersion> {
    protected final SimpleMultimap<String, T> versions = new SimpleMultimap(HashMap::new, TreeSet::new);
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public boolean isLoaded() {
        return !this.versions.isEmpty();
    }

    public boolean isLoaded(String gameVersion) {
        return !this.versions.get(gameVersion).isEmpty();
    }

    public abstract boolean hasType();

    public abstract Task<?> refreshAsync();

    public Task<?> refreshAsync(String gameVersion) {
        return this.refreshAsync();
    }

    public Task<?> loadAsync() {
        return Task.composeAsync(() -> {
            boolean loaded;
            this.lock.readLock().lock();
            try {
                loaded = this.isLoaded();
            }
            finally {
                this.lock.readLock().unlock();
            }
            return loaded ? null : this.refreshAsync();
        });
    }

    public Task<?> loadAsync(String gameVersion) {
        return Task.composeAsync(() -> {
            boolean loaded;
            this.lock.readLock().lock();
            try {
                loaded = this.isLoaded(gameVersion);
            }
            finally {
                this.lock.readLock().unlock();
            }
            return loaded ? null : this.refreshAsync(gameVersion);
        });
    }

    protected Collection<T> getVersionsImpl(String gameVersion) {
        return this.versions.get(gameVersion);
    }

    public final Collection<T> getVersions(String gameVersion) {
        this.lock.readLock().lock();
        try {
            Collection<T> collection = Collections.unmodifiableCollection(new ArrayList<T>(this.getVersionsImpl(gameVersion)));
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getVersion(String gameVersion, String remoteVersion) {
        this.lock.readLock().lock();
        try {
            RemoteVersion result = null;
            for (RemoteVersion it : this.versions.get(gameVersion)) {
                if (!remoteVersion.equals(it.getSelfVersion())) continue;
                result = it;
            }
            Optional<Object> optional = Optional.ofNullable(result);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

