/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.fabric;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.Nullable;

public final class FabricVersionList
extends VersionList<FabricRemoteVersion> {
    private final DownloadProvider downloadProvider;
    private static final String LOADER_META_URL = "https://meta.fabricmc.net/v2/versions/loader";
    private static final String GAME_META_URL = "https://meta.fabricmc.net/v2/versions/game";

    public FabricVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Task<?> refreshAsync() {
        return new Task<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws IOException {
                List gameVersions = FabricVersionList.this.getGameVersions(FabricVersionList.GAME_META_URL);
                List loaderVersions = FabricVersionList.this.getGameVersions(FabricVersionList.LOADER_META_URL);
                FabricVersionList.this.lock.writeLock().lock();
                try {
                    for (String gameVersion : gameVersions) {
                        for (String loaderVersion : loaderVersions) {
                            FabricVersionList.this.versions.put(gameVersion, new FabricRemoteVersion(gameVersion, loaderVersion, Collections.singletonList(FabricVersionList.getLaunchMetaUrl(gameVersion, loaderVersion))));
                        }
                    }
                }
                finally {
                    FabricVersionList.this.lock.writeLock().unlock();
                }
            }
        };
    }

    private List<String> getGameVersions(String metaUrl) throws IOException {
        String json = NetworkUtils.doGet(NetworkUtils.toURL(this.downloadProvider.injectURL(metaUrl)));
        return ((ArrayList)JsonUtils.GSON.fromJson(json, new TypeToken<ArrayList<GameVersion>>(){}.getType())).stream().map(GameVersion::getVersion).collect(Collectors.toList());
    }

    private static String getLaunchMetaUrl(String gameVersion, String loaderVersion) {
        return String.format("https://meta.fabricmc.net/v2/versions/loader/%s/%s", gameVersion, loaderVersion);
    }

    private static class GameVersion {
        private final String version;
        private final String maven;
        private final boolean stable;

        public GameVersion() {
            this("", null, false);
        }

        public GameVersion(String version, String maven, boolean stable) {
            this.version = version;
            this.maven = maven;
            this.stable = stable;
        }

        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getMaven() {
            return this.maven;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

