/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallProfile;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;

public class ForgeNewInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final DefaultGameRepository gameRepository;
    private final Version version;
    private final Path installer;
    private final List<Task<?>> dependents = new LinkedList();
    private final List<Task<?>> dependencies = new LinkedList();
    private ForgeNewInstallProfile profile;
    private Version forgeVersion;
    private final String selfVersion;

    ForgeNewInstallTask(DefaultDependencyManager dependencyManager, Version version, String selfVersion, Path installer) {
        this.dependencyManager = dependencyManager;
        this.gameRepository = dependencyManager.getGameRepository();
        this.version = version;
        this.installer = installer;
        this.selfVersion = selfVersion;
        this.setSignificance(Task.TaskSignificance.MINOR);
    }

    private <E extends Exception> String parseLiteral(String literal, Map<String, String> var, ExceptionalFunction<String, String, E> plainConverter) throws E {
        if (StringUtils.isSurrounded(literal, "{", "}")) {
            return var.get(StringUtils.removeSurrounding(literal, "{", "}"));
        }
        if (StringUtils.isSurrounded(literal, "'", "'")) {
            return StringUtils.removeSurrounding(literal, "'");
        }
        if (StringUtils.isSurrounded(literal, "[", "]")) {
            return this.gameRepository.getArtifactFile(this.version, Artifact.fromDescriptor(StringUtils.removeSurrounding(literal, "[", "]"))).toString();
        }
        return plainConverter.apply(literal);
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.installer);){
            this.profile = JsonUtils.fromNonNullJson(FileUtils.readText(fs.getPath("install_profile.json", new String[0])), ForgeNewInstallProfile.class);
            this.forgeVersion = JsonUtils.fromNonNullJson(FileUtils.readText(fs.getPath(this.profile.getJson(), new String[0])), Version.class);
            for (Library library : this.profile.getLibraries()) {
                Path file = fs.getPath("maven", new String[0]).resolve(library.getPath());
                if (!Files.exists(file, new LinkOption[0])) continue;
                Path dest = this.gameRepository.getLibraryFile(this.version, library).toPath();
                FileUtils.copyFile(file, dest);
            }
            Path mainJar = this.profile.getPath().getPath(fs.getPath("maven", new String[0]));
            if (Files.exists(mainJar, new LinkOption[0])) {
                Path dest = this.gameRepository.getArtifactFile(this.version, this.profile.getPath());
                FileUtils.copyFile(mainJar, dest);
            }
        }
        this.dependents.add(new GameLibrariesTask(this.dependencyManager, this.version, true, this.profile.getLibraries()));
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void execute() throws Exception {
        Path temp = Files.createTempDirectory("forge_installer", new FileAttribute[0]);
        int finished = 0;
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.installer);){
            List<ForgeNewInstallProfile.Processor> processors = this.profile.getProcessors();
            Map<String, String> data = this.profile.getData();
            this.updateProgress(0L, processors.size());
            for (Map.Entry<String, String> entry : data.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                data.put(key, this.parseLiteral(value, Collections.emptyMap(), str -> {
                    Path dest = Files.createTempFile(temp, null, null, new FileAttribute[0]);
                    FileUtils.copyFile(fs.getPath((String)str, new String[0]), dest);
                    return dest.toString();
                }));
            }
            data.put("SIDE", "client");
            data.put("MINECRAFT_JAR", this.gameRepository.getVersionJar(this.version).getAbsolutePath());
            for (ForgeNewInstallProfile.Processor processor : processors) {
                Object artifact3;
                String mainClass;
                Object value;
                HashMap<String, String> outputs = new HashMap<String, String>();
                boolean miss = false;
                for (Map.Entry<String, String> entry : processor.getOutputs().entrySet()) {
                    String key = entry.getKey();
                    value = entry.getValue();
                    key = this.parseLiteral(key, data, ExceptionalFunction.identity());
                    value = this.parseLiteral((String)value, data, ExceptionalFunction.identity());
                    if (key == null || value == null) {
                        throw new ArtifactMalformedException("Invalid forge installation configuration");
                    }
                    outputs.put(key, (String)value);
                    Path artifact2 = Paths.get(key, new String[0]);
                    if (Files.exists(artifact2, new LinkOption[0])) {
                        String code;
                        try (InputStream stream = Files.newInputStream(artifact2, new OpenOption[0]);){
                            code = Hex.encodeHex(DigestUtils.digest("SHA-1", stream));
                        }
                        if (Objects.equals(code, value)) continue;
                        Files.delete(artifact2);
                        Logging.LOG.info("Found existing file is not valid: " + artifact2);
                        miss = true;
                        continue;
                    }
                    miss = true;
                }
                if (!processor.getOutputs().isEmpty() && !miss) continue;
                Path jar = this.gameRepository.getArtifactFile(this.version, processor.getJar());
                if (!Files.isRegularFile(jar, new LinkOption[0])) {
                    throw new FileNotFoundException("Game processor file not found, should be downloaded in preprocess");
                }
                JarFile jarFile = new JarFile(jar.toFile());
                value = null;
                try {
                    mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                }
                catch (Throwable artifact2) {
                    value = artifact2;
                    throw artifact2;
                }
                finally {
                    if (jarFile != null) {
                        if (value != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable artifact2) {
                                ((Throwable)value).addSuppressed(artifact2);
                            }
                        } else {
                            jarFile.close();
                        }
                    }
                }
                if (StringUtils.isBlank(mainClass)) {
                    throw new Exception("Game processor jar does not have main class " + jar);
                }
                ArrayList<String> command = new ArrayList<String>();
                command.add(JavaVersion.fromCurrentEnvironment().getBinary().toString());
                command.add("-cp");
                ArrayList<String> classpath = new ArrayList<String>(processor.getClasspath().size() + 1);
                for (Object artifact3 : processor.getClasspath()) {
                    Path file = this.gameRepository.getArtifactFile(this.version, (Artifact)artifact3);
                    if (!Files.isRegularFile(file, new LinkOption[0])) {
                        throw new Exception("Game processor dependency missing");
                    }
                    classpath.add(file.toString());
                }
                classpath.add(jar.toString());
                command.add(String.join((CharSequence)OperatingSystem.PATH_SEPARATOR, classpath));
                command.add(mainClass);
                ArrayList<String> args = new ArrayList<String>(processor.getArgs().size());
                artifact3 = processor.getArgs().iterator();
                while (artifact3.hasNext()) {
                    String arg = (String)artifact3.next();
                    String parsed = this.parseLiteral(arg, data, ExceptionalFunction.identity());
                    if (parsed == null) {
                        throw new ArtifactMalformedException("Invalid forge installation configuration");
                    }
                    args.add(parsed);
                }
                command.addAll(args);
                Logging.LOG.info("Executing external processor " + processor.getJar().toString() + ", command line: " + new CommandBuilder().addAll(command).toString());
                int exitCode = SystemUtils.callExternalProcess(command);
                if (exitCode != 0) {
                    throw new IOException("Game processor exited abnormally");
                }
                for (Map.Entry entry : outputs.entrySet()) {
                    String code;
                    Path artifact4 = Paths.get((String)entry.getKey(), new String[0]);
                    if (!Files.isRegularFile(artifact4, new LinkOption[0])) {
                        throw new FileNotFoundException("File missing: " + artifact4);
                    }
                    try (InputStream stream = Files.newInputStream(artifact4, new OpenOption[0]);){
                        code = Hex.encodeHex(DigestUtils.digest("SHA-1", stream));
                    }
                    if (Objects.equals(code, entry.getValue())) continue;
                    Files.delete(artifact4);
                    throw new ChecksumMismatchException("SHA-1", (String)entry.getValue(), code);
                }
                this.updateProgress(++finished, processors.size());
            }
        }
        catch (ZipException ex) {
            throw new ArtifactMalformedException("Malformed forge installer file", ex);
        }
        this.setResult(this.forgeVersion.setPriority(30000).setId(LibraryAnalyzer.LibraryType.FORGE.getPatchId()).setVersion(this.selfVersion));
        this.dependencies.add(this.dependencyManager.checkLibraryCompletionAsync(this.forgeVersion, true));
        FileUtils.deleteDirectory(temp.toFile());
    }
}

