/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.forge.ForgeInstallProfile;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;

public class ForgeOldInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private final Path installer;
    private final String selfVersion;
    private final List<Task<?>> dependencies = new LinkedList();

    ForgeOldInstallTask(DefaultDependencyManager dependencyManager, Version version, String selfVersion, Path installer) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.installer = installer;
        this.selfVersion = selfVersion;
        this.setSignificance(Task.TaskSignificance.MINOR);
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        try (ZipFile zipFile = new ZipFile(this.installer.toFile());){
            InputStream stream = zipFile.getInputStream(zipFile.getEntry("install_profile.json"));
            if (stream == null) {
                throw new ArtifactMalformedException("Malformed forge installer file, install_profile.json does not exist.");
            }
            String json = IOUtils.readFullyAsString(stream);
            ForgeInstallProfile installProfile = JsonUtils.fromNonNullJson(json, ForgeInstallProfile.class);
            Library forgeLibrary = new Library(installProfile.getInstall().getPath());
            File forgeFile = this.dependencyManager.getGameRepository().getLibraryFile(this.version, forgeLibrary);
            if (!FileUtils.makeFile(forgeFile)) {
                throw new IOException("Cannot make directory " + forgeFile.getParent());
            }
            ZipEntry forgeEntry = zipFile.getEntry(installProfile.getInstall().getFilePath());
            try (InputStream is = zipFile.getInputStream(forgeEntry);
                 FileOutputStream os = new FileOutputStream(forgeFile);){
                IOUtils.copyTo(is, os);
            }
            this.setResult(installProfile.getVersionInfo().setPriority(30000).setId(LibraryAnalyzer.LibraryType.FORGE.getPatchId()).setVersion(this.selfVersion));
            this.dependencies.add(this.dependencyManager.checkLibraryCompletionAsync(installProfile.getVersionInfo(), true));
        }
        catch (ZipException ex) {
            throw new ArtifactMalformedException("Malformed forge installer file", ex);
        }
    }
}

