/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.download.game.GameDownloadTask;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.game.VersionJsonDownloadTask;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;

public class GameInstallTask
extends Task<Version> {
    private final DefaultGameRepository gameRepository;
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private final GameRemoteVersion remote;
    private final VersionJsonDownloadTask downloadTask;
    private final List<Task<?>> dependencies = new LinkedList();

    public GameInstallTask(DefaultDependencyManager dependencyManager, Version version, GameRemoteVersion remoteVersion) {
        this.dependencyManager = dependencyManager;
        this.gameRepository = dependencyManager.getGameRepository();
        this.version = version;
        this.remote = remoteVersion;
        this.downloadTask = new VersionJsonDownloadTask(remoteVersion.getGameVersion(), dependencyManager);
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.downloadTask);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        Version patch = JsonUtils.fromNonNullJson((String)this.downloadTask.getResult(), Version.class).setId(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId()).setVersion(this.remote.getGameVersion()).setJar(null).setPriority(0);
        this.setResult(patch);
        Version version = new Version(this.version.getId()).addPatch(patch);
        this.dependencies.add(Task.allOf(new GameDownloadTask(this.dependencyManager, this.remote.getGameVersion(), version), Task.allOf(new GameAssetDownloadTask(this.dependencyManager, version, true, true), new GameLibrariesTask(this.dependencyManager, version, true)).withStage("hmcl.install.assets").withRunAsync(() -> {})).thenComposeAsync(this.gameRepository.saveAsync(version)));
    }
}

