/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jackhuang.hmcl.game.AssetIndex;
import org.jackhuang.hmcl.game.AssetObject;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LoggingInfo;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.game.VersionNotFoundException;
import org.jackhuang.hmcl.game.VersionProvider;
import org.jackhuang.hmcl.task.Task;

public interface GameRepository
extends VersionProvider {
    @Override
    public boolean hasVersion(String var1);

    @Override
    public Version getVersion(String var1) throws VersionNotFoundException;

    default public Version getResolvedVersion(String id) throws VersionNotFoundException {
        return this.getVersion(id).resolve(this);
    }

    default public Version getResolvedPreservingPatchesVersion(String id) throws VersionNotFoundException {
        return this.getVersion(id).resolvePreservingPatches(this);
    }

    public int getVersionCount();

    public Collection<Version> getVersions();

    public void refreshVersions();

    default public Task<Void> refreshVersionsAsync() {
        return Task.runAsync(this::refreshVersions);
    }

    public File getVersionRoot(String var1);

    public File getRunDirectory(String var1);

    public File getLibrariesDirectory(Version var1);

    public File getLibraryFile(Version var1, Library var2);

    public File getNativeDirectory(String var1);

    public File getVersionJar(Version var1);

    default public File getVersionJar(String version) throws VersionNotFoundException {
        return this.getVersionJar(this.getVersion(version).resolve(this));
    }

    public boolean renameVersion(String var1, String var2);

    public File getActualAssetDirectory(String var1, String var2);

    public File getAssetDirectory(String var1, String var2);

    public File getAssetObject(String var1, String var2, String var3) throws IOException;

    public File getAssetObject(String var1, String var2, AssetObject var3);

    public AssetIndex getAssetIndex(String var1, String var2) throws IOException;

    public File getIndexFile(String var1, String var2);

    public File getLoggingObject(String var1, String var2, LoggingInfo var3);
}

