/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jenkinsci.constant_pool_scanner.ConstantPool;
import org.jenkinsci.constant_pool_scanner.ConstantPoolScanner;
import org.jenkinsci.constant_pool_scanner.ConstantType;
import org.jenkinsci.constant_pool_scanner.StringConstant;

public final class GameVersion {
    private static Optional<String> getVersionFromJson(Path versionJson) {
        try {
            Map version = JsonUtils.fromNonNullJson(FileUtils.readText(versionJson), Map.class);
            return Lang.tryCast(version.get("name"), String.class);
        }
        catch (JsonParseException | IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to parse version.json", e);
            return Optional.empty();
        }
    }

    private static Optional<String> getVersionOfClassMinecraft(byte[] bytecode) throws IOException {
        ConstantPool pool = ConstantPoolScanner.parse(bytecode, ConstantType.STRING);
        return StreamSupport.stream(pool.list(StringConstant.class).spliterator(), false).map(StringConstant::get).filter(s -> s.startsWith("Minecraft Minecraft ")).map(s -> s.substring("Minecraft Minecraft ".length())).findFirst();
    }

    private static Optional<String> getVersionFromClassMinecraftServer(byte[] bytecode) throws IOException {
        int i;
        ConstantPool pool = ConstantPoolScanner.parse(bytecode, ConstantType.STRING);
        List list = StreamSupport.stream(pool.list(StringConstant.class).spliterator(), false).map(StringConstant::get).collect(Collectors.toList());
        int idx = -1;
        for (i = 0; i < list.size(); ++i) {
            if (!((String)list.get(i)).startsWith("Can't keep up!")) continue;
            idx = i;
            break;
        }
        for (i = idx - 1; i >= 0; --i) {
            if (!((String)list.get(i)).matches(".*[0-9].*")) continue;
            return Optional.of(list.get(i));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> minecraftVersion(File file) {
        if (file == null) return Optional.empty();
        if (!file.exists()) return Optional.empty();
        if (!file.isFile()) return Optional.empty();
        if (!file.canRead()) {
            return Optional.empty();
        }
        try (FileSystem gameJar = CompressingUtils.createReadOnlyZipFileSystem(file.toPath());){
            Optional<String> result;
            Optional<String> result2;
            Path versionJson = gameJar.getPath("version.json", new String[0]);
            if (Files.exists(versionJson, new LinkOption[0]) && (result2 = GameVersion.getVersionFromJson(versionJson)).isPresent()) {
                Optional<String> optional = result2;
                return optional;
            }
            Path minecraft = gameJar.getPath("net/minecraft/client/Minecraft.class", new String[0]);
            if (Files.exists(minecraft, new LinkOption[0]) && (result = GameVersion.getVersionOfClassMinecraft(Files.readAllBytes(minecraft))).isPresent()) {
                Optional<String> optional = result;
                return optional;
            }
            Path minecraftServer = gameJar.getPath("net/minecraft/server/MinecraftServer.class", new String[0]);
            if (Files.exists(minecraftServer, new LinkOption[0])) {
                Optional<String> optional = GameVersion.getVersionFromClassMinecraftServer(Files.readAllBytes(minecraftServer));
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

