/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.ProxyManager;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.JavaVersion;

public class HMCLGameRepository
extends DefaultGameRepository {
    private final Profile profile;
    private final Map<String, VersionSetting> localVersionSettings = new HashMap<String, VersionSetting>();
    private final Set<String> beingModpackVersions = new HashSet<String>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final HashSet<String> FORBIDDEN = new HashSet<String>(Arrays.asList("modpack", "minecraftinstance", "manifest"));
    private static final String PROFILE = "{\"selectedProfile\": \"(Default)\",\"profiles\": {\"(Default)\": {\"name\": \"(Default)\"}},\"clientToken\": \"88888888-8888-8888-8888-888888888888\"}";

    public HMCLGameRepository(Profile profile, File baseDirectory) {
        super(baseDirectory);
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public GameDirectoryType getGameDirectoryType(String id) {
        if (this.beingModpackVersions.contains(id) || this.isModpack(id)) {
            return GameDirectoryType.VERSION_FOLDER;
        }
        return this.getVersionSetting(id).getGameDirType();
    }

    @Override
    public File getRunDirectory(String id) {
        switch (this.getGameDirectoryType(id)) {
            case VERSION_FOLDER: {
                return this.getVersionRoot(id);
            }
            case ROOT_FOLDER: {
                return super.getRunDirectory(id);
            }
            case CUSTOM: {
                File dir = new File(this.getVersionSetting(id).getGameDir());
                if (!FileUtils.isValidPath(dir)) {
                    return this.getVersionRoot(id);
                }
                return dir;
            }
        }
        throw new Error();
    }

    @Override
    protected void refreshVersionsImpl() {
        this.localVersionSettings.clear();
        super.refreshVersionsImpl();
        this.versions.keySet().forEach(this::loadLocalVersionSetting);
        this.versions.keySet().forEach(version -> {
            if (this.isModpack((String)version)) {
                this.specializeVersionSetting((String)version);
            }
        });
        try {
            File file = new File(this.getBaseDirectory(), "launcher_profiles.json");
            if (!file.exists() && !this.versions.isEmpty()) {
                FileUtils.writeText(file, PROFILE);
            }
        }
        catch (IOException ex) {
            Logging.LOG.log(Level.WARNING, "Unable to create launcher_profiles.json, Forge/LiteLoader installer will not work.", ex);
        }
    }

    public void changeDirectory(File newDirectory) {
        this.setBaseDirectory(newDirectory);
        this.refreshVersionsAsync().start();
    }

    private void clean(File directory) throws IOException {
        FileUtils.deleteDirectory(new File(directory, "crash-reports"));
        FileUtils.deleteDirectory(new File(directory, "logs"));
    }

    public void clean(String id) throws IOException {
        this.clean(this.getBaseDirectory());
        this.clean(this.getRunDirectory(id));
    }

    public void duplicateVersion(String srcId, String dstId, boolean copySaves) throws IOException {
        File srcDir = this.getVersionRoot(srcId);
        File dstDir = this.getVersionRoot(dstId);
        if (dstDir.exists()) {
            throw new IOException("Version exists");
        }
        FileUtils.copyDirectory(srcDir.toPath(), dstDir.toPath());
        Files.move(dstDir.toPath().resolve(srcId + ".jar"), dstDir.toPath().resolve(dstId + ".jar"), new CopyOption[0]);
        Files.move(dstDir.toPath().resolve(srcId + ".json"), dstDir.toPath().resolve(dstId + ".json"), new CopyOption[0]);
        VersionSetting oldVersionSetting = this.getVersionSetting(srcId).clone();
        GameDirectoryType originalGameDirType = oldVersionSetting.getGameDirType();
        oldVersionSetting.setUsesGlobal(false);
        oldVersionSetting.setGameDirType(GameDirectoryType.VERSION_FOLDER);
        VersionSetting newVersionSetting = this.initLocalVersionSetting(dstId, oldVersionSetting);
        this.saveVersionSetting(dstId);
        File srcGameDir = this.getRunDirectory(srcId);
        File dstGameDir = this.getRunDirectory(dstId);
        ArrayList<String> blackList = new ArrayList<String>(Arrays.asList("regex:(.*?)\\.log", "usernamecache.json", "usercache.json", "launcher_profiles.json", "launcher.pack.lzma", "backup", "pack.json", "launcher.jar", "cache", ".curseclient", ".fabric", ".mixin.out", "jars", "logs", "versions", "assets", "libraries", "crash-reports", "NVIDIA", "AMD", "screenshots", "natives", "native", "$native", "server-resource-packs", "downloads", "asm", "backups", "TCNodeTracker", "CustomDISkins", "data", "CustomSkinLoader/caches"));
        blackList.add(srcId + ".jar");
        blackList.add(srcId + ".json");
        if (!copySaves) {
            blackList.add("saves");
        }
        if (originalGameDirType != GameDirectoryType.VERSION_FOLDER) {
            FileUtils.copyDirectory(srcGameDir.toPath(), dstGameDir.toPath(), path -> Modpack.acceptFile(path, blackList, null));
        }
    }

    private File getLocalVersionSettingFile(String id) {
        return new File(this.getVersionRoot(id), "hmclversion.cfg");
    }

    private void loadLocalVersionSetting(String id) {
        File file = this.getLocalVersionSettingFile(id);
        if (file.exists()) {
            try {
                VersionSetting versionSetting = GSON.fromJson(FileUtils.readText(file), VersionSetting.class);
                this.initLocalVersionSetting(id, versionSetting);
            }
            catch (Exception ex) {
                this.initLocalVersionSetting(id, new VersionSetting());
            }
        }
    }

    public VersionSetting createLocalVersionSetting(String id) {
        if (!this.hasVersion(id)) {
            return null;
        }
        if (this.localVersionSettings.containsKey(id)) {
            return this.getLocalVersionSetting(id);
        }
        return this.initLocalVersionSetting(id, new VersionSetting());
    }

    private VersionSetting initLocalVersionSetting(String id, VersionSetting vs) {
        this.localVersionSettings.put(id, vs);
        vs.addPropertyChangedListener(a -> this.saveVersionSetting(id));
        return vs;
    }

    public VersionSetting getLocalVersionSetting(String id) {
        VersionSetting setting;
        if (!this.localVersionSettings.containsKey(id)) {
            this.loadLocalVersionSetting(id);
        }
        if ((setting = this.localVersionSettings.get(id)) != null && this.isModpack(id)) {
            setting.setGameDirType(GameDirectoryType.VERSION_FOLDER);
        }
        return setting;
    }

    public VersionSetting getVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null || vs.isUsesGlobal()) {
            this.profile.getGlobal().setGlobal(true);
            this.profile.getGlobal().setUsesGlobal(true);
            return this.profile.getGlobal();
        }
        return vs;
    }

    public File getVersionIconFile(String id) {
        return new File(this.getVersionRoot(id), "icon.png");
    }

    public Image getVersionIconImage(String id) {
        if (id == null || !this.isLoaded()) {
            return FXUtils.newImage("/assets/img/grass.png");
        }
        Version version = this.getVersion(id).resolve(this);
        File iconFile = this.getVersionIconFile(id);
        if (iconFile.exists()) {
            return new Image("file:" + iconFile.getAbsolutePath());
        }
        if (version.getMainClass() != null && ("net.minecraft.launchwrapper.Launch".equals(version.getMainClass()) || version.getMainClass().startsWith("net.fabricmc") || "cpw.mods.modlauncher.Launcher".equals(version.getMainClass()))) {
            return FXUtils.newImage("/assets/img/furnace.png");
        }
        return FXUtils.newImage("/assets/img/grass.png");
    }

    public boolean saveVersionSetting(String id) {
        if (!this.localVersionSettings.containsKey(id)) {
            return false;
        }
        File file = this.getLocalVersionSettingFile(id);
        if (!FileUtils.makeDirectory(file.getAbsoluteFile().getParentFile())) {
            return false;
        }
        try {
            FileUtils.writeText(file, GSON.toJson(this.localVersionSettings.get(id)));
            return true;
        }
        catch (IOException e) {
            Logging.LOG.log(Level.SEVERE, "Unable to save version setting of " + id, e);
            return false;
        }
    }

    public VersionSetting specializeVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null) {
            vs = this.createLocalVersionSetting(id);
        }
        if (vs == null) {
            return null;
        }
        vs.setUsesGlobal(false);
        return vs;
    }

    public void globalizeVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs != null) {
            vs.setUsesGlobal(true);
        }
    }

    public boolean forbidsVersion(String id) {
        return FORBIDDEN.contains(id);
    }

    public LaunchOptions getLaunchOptions(String version, File gameDir, boolean checkJava) throws InterruptedException {
        File json;
        VersionSetting vs = this.getVersionSetting(version);
        JavaVersion javaVersion = Optional.ofNullable(vs.getJavaVersion(checkJava)).orElse(JavaVersion.fromCurrentEnvironment());
        LaunchOptions.Builder builder = new LaunchOptions.Builder().setGameDir(gameDir).setJava(javaVersion).setVersionName(Metadata.TITLE).setVersionType(Metadata.TITLE).setProfileName(Metadata.TITLE).setGameArguments(StringUtils.tokenize(vs.getMinecraftArgs())).setJavaArguments(StringUtils.tokenize(vs.getJavaArgs())).setMaxMemory(vs.getMaxMemory()).setMinMemory(vs.getMinMemory()).setMetaspace(Lang.toIntOrNull(vs.getPermSize())).setWidth(vs.getWidth()).setHeight(vs.getHeight()).setFullscreen(vs.isFullscreen()).setServerIp(vs.getServerIp()).setWrapper(vs.getWrapper()).setPrecalledCommand(vs.getPreLaunchCommand()).setNoGeneratedJVMArgs(vs.isNoJVMArgs());
        if (ConfigHolder.config().hasProxy()) {
            builder.setProxy(ProxyManager.getProxy());
            if (ConfigHolder.config().hasProxyAuth()) {
                builder.setProxyUser(ConfigHolder.config().getProxyUser());
                builder.setProxyPass(ConfigHolder.config().getProxyPass());
            }
        }
        if ((json = this.getModpackConfiguration(version)).exists()) {
            try {
                String jsonText = FileUtils.readText(json);
                ModpackConfiguration modpackConfiguration = JsonUtils.GSON.fromJson(jsonText, ModpackConfiguration.class);
                if ("Mcbbs".equals(modpackConfiguration.getType())) {
                    ModpackConfiguration config = (ModpackConfiguration)JsonUtils.GSON.fromJson(FileUtils.readText(json), new TypeToken<ModpackConfiguration<McbbsModpackManifest>>(){}.getType());
                    ((McbbsModpackManifest)config.getManifest()).injectLaunchOptions(builder);
                }
            }
            catch (JsonParseException | IOException e) {
                e.printStackTrace();
            }
        }
        return builder.create();
    }

    @Override
    public File getModpackConfiguration(String version) {
        return new File(this.getVersionRoot(version), "modpack.cfg");
    }

    public void markVersionAsModpack(String id) {
        this.beingModpackVersions.add(id);
    }

    public void undoMark(String id) {
        this.beingModpackVersions.remove(id);
    }

    public void markVersionLaunchedAbnormally(String id) {
        try {
            Files.createFile(this.getVersionRoot(id).toPath().resolve(".abnormal"), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean unmarkVersionLaunchedAbnormally(String id) {
        File file = new File(this.getVersionRoot(id), ".abnormal");
        boolean result = file.isFile();
        file.delete();
        return result;
    }
}

