/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.Serializable;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jetbrains.annotations.NotNull;

public class LaunchOptions
implements Serializable {
    private File gameDir;
    private JavaVersion java;
    private String versionName;
    private String versionType;
    private String profileName;
    private List<String> gameArguments = new ArrayList<String>();
    private List<String> javaArguments = new ArrayList<String>();
    private Integer minMemory;
    private Integer maxMemory;
    private Integer metaspace;
    private Integer width;
    private Integer height;
    private boolean fullscreen;
    private String serverIp;
    private String wrapper;
    private Proxy proxy;
    private String proxyUser;
    private String proxyPass;
    private boolean noGeneratedJVMArgs;
    private String preLaunchCommand;

    public File getGameDir() {
        return this.gameDir;
    }

    public JavaVersion getJava() {
        return this.java;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public String getProfileName() {
        return this.profileName;
    }

    @NotNull
    public List<String> getGameArguments() {
        return Collections.unmodifiableList(this.gameArguments);
    }

    @NotNull
    public List<String> getJavaArguments() {
        return Collections.unmodifiableList(this.javaArguments);
    }

    public Integer getMinMemory() {
        return this.minMemory;
    }

    public Integer getMaxMemory() {
        return this.maxMemory;
    }

    public Integer getMetaspace() {
        return this.metaspace;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getWrapper() {
        return this.wrapper;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public boolean isNoGeneratedJVMArgs() {
        return this.noGeneratedJVMArgs;
    }

    public String getPreLaunchCommand() {
        return this.preLaunchCommand;
    }

    public static class Builder {
        private final LaunchOptions options = new LaunchOptions();

        public LaunchOptions create() {
            return this.options;
        }

        public File getGameDir() {
            return this.options.gameDir;
        }

        public JavaVersion getJava() {
            return this.options.java;
        }

        public String getVersionName() {
            return this.options.versionName;
        }

        public String getVersionType() {
            return this.options.versionType;
        }

        public String getProfileName() {
            return this.options.profileName;
        }

        public List<String> getGameArguments() {
            return this.options.gameArguments;
        }

        public List<String> getJavaArguments() {
            return this.options.javaArguments;
        }

        public Integer getMinMemory() {
            return this.options.minMemory;
        }

        public Integer getMaxMemory() {
            return this.options.maxMemory;
        }

        public Integer getMetaspace() {
            return this.options.metaspace;
        }

        public Integer getWidth() {
            return this.options.width;
        }

        public Integer getHeight() {
            return this.options.height;
        }

        public boolean isFullscreen() {
            return this.options.fullscreen;
        }

        public String getServerIp() {
            return this.options.serverIp;
        }

        public String getWrapper() {
            return this.options.wrapper;
        }

        public Proxy getProxy() {
            return this.options.proxy;
        }

        public String getProxyUser() {
            return this.options.proxyUser;
        }

        public String getProxyPass() {
            return this.options.proxyPass;
        }

        public boolean isNoGeneratedJVMArgs() {
            return this.options.noGeneratedJVMArgs;
        }

        public String getPreLaunchCommand() {
            return this.options.preLaunchCommand;
        }

        public Builder setGameDir(File gameDir) {
            this.options.gameDir = gameDir;
            return this;
        }

        public Builder setJava(JavaVersion java) {
            this.options.java = java;
            return this;
        }

        public Builder setVersionName(String versionName) {
            this.options.versionName = versionName;
            return this;
        }

        public Builder setVersionType(String versionType) {
            this.options.versionType = versionType;
            return this;
        }

        public Builder setProfileName(String profileName) {
            this.options.profileName = profileName;
            return this;
        }

        public Builder setGameArguments(List<String> gameArguments) {
            this.options.gameArguments.clear();
            this.options.gameArguments.addAll(gameArguments);
            return this;
        }

        public Builder setJavaArguments(List<String> javaArguments) {
            this.options.javaArguments.clear();
            this.options.javaArguments.addAll(javaArguments);
            return this;
        }

        public Builder setMinMemory(Integer minMemory) {
            this.options.minMemory = minMemory;
            return this;
        }

        public Builder setMaxMemory(Integer maxMemory) {
            this.options.maxMemory = maxMemory;
            return this;
        }

        public Builder setMetaspace(Integer metaspace) {
            this.options.metaspace = metaspace;
            return this;
        }

        public Builder setWidth(Integer width) {
            this.options.width = width;
            return this;
        }

        public Builder setHeight(Integer height) {
            this.options.height = height;
            return this;
        }

        public Builder setFullscreen(boolean fullscreen) {
            this.options.fullscreen = fullscreen;
            return this;
        }

        public Builder setServerIp(String serverIp) {
            this.options.serverIp = serverIp;
            return this;
        }

        public Builder setWrapper(String wrapper) {
            this.options.wrapper = wrapper;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.options.proxy = proxy;
            return this;
        }

        public Builder setProxyUser(String proxyUser) {
            this.options.proxyUser = proxyUser;
            return this;
        }

        public Builder setProxyPass(String proxyPass) {
            this.options.proxyPass = proxyPass;
            return this;
        }

        public Builder setNoGeneratedJVMArgs(boolean noGeneratedJVMArgs) {
            this.options.noGeneratedJVMArgs = noGeneratedJVMArgs;
            return this;
        }

        public Builder setPrecalledCommand(String precalledCommand) {
            this.options.preLaunchCommand = precalledCommand;
            return this;
        }
    }
}

