/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.MaintainTask;
import org.jackhuang.hmcl.download.game.GameAssetIndexDownloadTask;
import org.jackhuang.hmcl.download.game.GameVerificationFixTask;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.game.HMCLGameLauncher;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.curse.CurseCompletionException;
import org.jackhuang.hmcl.mod.curse.CurseCompletionTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackCompletionTask;
import org.jackhuang.hmcl.mod.server.ServerModpackCompletionTask;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.DialogController;
import org.jackhuang.hmcl.ui.LogWindow;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class LauncherHelper {
    private final Profile profile;
    private final Account account;
    private final String selectedVersion;
    private File scriptFile;
    private final VersionSetting setting;
    private LauncherVisibility launcherVisibility;
    private boolean showLogs;
    private final TaskExecutorDialogPane launchingStepsPane = new TaskExecutorDialogPane(it -> {});
    public static final Queue<ManagedProcess> PROCESSES = new ConcurrentLinkedQueue<ManagedProcess>();

    public LauncherHelper(Profile profile, Account account, String selectedVersion) {
        this.profile = Objects.requireNonNull(profile);
        this.account = Objects.requireNonNull(account);
        this.selectedVersion = Objects.requireNonNull(selectedVersion);
        this.setting = profile.getVersionSetting(selectedVersion);
        this.launcherVisibility = this.setting.getLauncherVisibility();
        this.showLogs = this.setting.isShowLogs();
        this.launchingStepsPane.setTitle(I18n.i18n("version.launch"));
    }

    public void setTestMode() {
        this.launcherVisibility = LauncherVisibility.KEEP;
        this.showLogs = true;
    }

    public void launch() {
        Logging.LOG.info("Launching game version: " + this.selectedVersion);
        HMCLGameRepository repository = this.profile.getRepository();
        Version version = repository.getResolvedVersion(this.selectedVersion);
        Platform.runLater(() -> {
            try {
                LauncherHelper.checkGameState(this.profile, this.setting, version, () -> {
                    Controllers.dialog((Region)this.launchingStepsPane);
                    Schedulers.defaultScheduler().execute(this::launch0);
                });
            }
            catch (InterruptedException | RejectedExecutionException exception) {
                // empty catch block
            }
        });
    }

    public void makeLaunchScript(File scriptFile) {
        this.scriptFile = Objects.requireNonNull(scriptFile);
        this.launch();
    }

    private void launch0() {
        HMCLGameRepository repository = this.profile.getRepository();
        DefaultDependencyManager dependencyManager = this.profile.getDependency();
        Version version = MaintainTask.maintain(repository, repository.getResolvedVersion(this.selectedVersion));
        Optional<String> gameVersion = GameVersion.minecraftVersion(repository.getVersionJar(version));
        boolean integrityCheck = repository.unmarkVersionLaunchedAbnormally(this.selectedVersion);
        CountDownLatch launchingLatch = new CountDownLatch(1);
        TaskExecutor executor = dependencyManager.checkPatchCompletionAsync(repository.getVersion(this.selectedVersion), integrityCheck).thenComposeAsync(Task.allOf(Task.composeAsync(() -> {
            if (this.setting.isNotCheckGame()) {
                return null;
            }
            return dependencyManager.checkGameCompletionAsync(version, integrityCheck);
        }), Task.composeAsync(() -> {
            try {
                ModpackConfiguration<?> configuration = ModpackHelper.readModpackConfiguration(repository.getModpackConfiguration(this.selectedVersion));
                if ("Curse".equals(configuration.getType())) {
                    return new CurseCompletionTask(dependencyManager, this.selectedVersion);
                }
                if ("Server".equals(configuration.getType())) {
                    return new ServerModpackCompletionTask(dependencyManager, this.selectedVersion);
                }
                if ("Mcbbs".equals(configuration.getType())) {
                    return new McbbsModpackCompletionTask(dependencyManager, this.selectedVersion);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }))).withStage("launch.state.dependencies").thenComposeAsync(() -> gameVersion.map(s -> new GameVerificationFixTask(dependencyManager, (String)s, version)).orElse(null)).thenComposeAsync(Task.supplyAsync(() -> {
            try {
                return this.account.logIn();
            }
            catch (CredentialExpiredException e) {
                Logging.LOG.info("Credential has expired: " + e);
                return DialogController.logIn(this.account);
            }
            catch (AuthenticationException e) {
                Logging.LOG.warning("Authentication failed, try playing offline: " + e);
                return this.account.playOffline().orElseThrow(() -> e);
            }
        }).withStage("launch.state.logging_in")).thenComposeAsync(authInfo -> Task.supplyAsync(() -> new HMCLGameLauncher(repository, version.getPatches().isEmpty() ? repository.getResolvedVersion(this.selectedVersion) : version, (AuthInfo)authInfo, repository.getLaunchOptions(this.selectedVersion, this.profile.getGameDir(), !this.setting.isNotCheckJVM()), this.launcherVisibility == LauncherVisibility.CLOSE ? null : new HMCLProcessListener(repository, this.selectedVersion, (AuthInfo)authInfo, launchingLatch, gameVersion.isPresent()))).thenComposeAsync(launcher -> {
            if (this.scriptFile == null) {
                return Task.supplyAsync(launcher::launch);
            }
            return Task.supplyAsync(() -> {
                launcher.makeLaunchScript(this.scriptFile);
                return null;
            });
        }).thenAcceptAsync(process -> {
            if (this.scriptFile == null) {
                PROCESSES.add((ManagedProcess)process);
                if (this.launcherVisibility == LauncherVisibility.CLOSE) {
                    Launcher.stopApplication();
                } else {
                    this.launchingStepsPane.setCancel(it -> {
                        process.stop();
                        it.fireEvent((Event)new DialogCloseEvent());
                    });
                }
            } else {
                Platform.runLater(() -> {
                    this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                    Controllers.dialog(I18n.i18n("version.launch_script.success", this.scriptFile.getAbsolutePath()));
                });
            }
        }).thenRunAsync(() -> launchingLatch.await()).withStage("launch.state.waiting_launching")).withStagesHint(Lang.immutableListOf("launch.state.dependencies", "launch.state.logging_in", "launch.state.waiting_launching")).executor();
        this.launchingStepsPane.setExecutor(executor, false);
        executor.addTaskListener(new TaskListener(){

            @Override
            public void onStop(boolean success, TaskExecutor executor) {
                Platform.runLater(() -> {
                    if (!Controllers.isStopped()) {
                        Exception ex;
                        LauncherHelper.this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                        if (!success && (ex = executor.getException()) != null) {
                            String message;
                            if (ex instanceof CurseCompletionException) {
                                message = ex.getCause() instanceof FileNotFoundException ? I18n.i18n("modpack.type.curse.not_found") : I18n.i18n("modpack.type.curse.error");
                            } else if (ex instanceof PermissionException) {
                                message = I18n.i18n("launch.failed.executable_permission");
                            } else if (ex instanceof ProcessCreationException) {
                                message = I18n.i18n("launch.failed.creating_process") + ex.getLocalizedMessage();
                            } else if (ex instanceof NotDecompressingNativesException) {
                                message = I18n.i18n("launch.failed.decompressing_natives") + ex.getLocalizedMessage();
                            } else if (ex instanceof LibraryDownloadException) {
                                message = I18n.i18n("launch.failed.download_library", ((LibraryDownloadException)ex).getLibrary().getName()) + "\n";
                                if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException rce = (ResponseCodeException)ex.getCause();
                                    int responseCode = rce.getResponseCode();
                                    URL url = rce.getUrl();
                                    message = responseCode == 404 ? message + I18n.i18n("download.code.404", url) : message + I18n.i18n("download.failed", url, responseCode);
                                } else {
                                    message = message + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof DownloadException) {
                                URL url = ((DownloadException)ex).getUrl();
                                if (ex.getCause() instanceof SocketTimeoutException) {
                                    message = I18n.i18n("install.failed.downloading.timeout", url);
                                } else if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException responseCodeException = (ResponseCodeException)ex.getCause();
                                    message = I18n.hasKey("download.code." + responseCodeException.getResponseCode()) ? I18n.i18n("download.code." + responseCodeException.getResponseCode(), url) : I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(ex.getCause());
                                } else {
                                    message = I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof GameAssetIndexDownloadTask.GameAssetIndexMalformedException) {
                                message = I18n.i18n("assets.index.malformed");
                            } else if (ex instanceof AuthlibInjectorDownloadException) {
                                message = I18n.i18n("account.failed.injector_download_failure");
                            } else if (ex instanceof CharacterDeletedException) {
                                message = I18n.i18n("account.failed.character_deleted");
                            } else if (ex instanceof ResponseCodeException) {
                                ResponseCodeException rce = (ResponseCodeException)ex;
                                int responseCode = rce.getResponseCode();
                                URL url = rce.getUrl();
                                message = responseCode == 404 ? I18n.i18n("download.code.404", url) : I18n.i18n("download.failed", url, responseCode);
                            } else {
                                message = StringUtils.getStackTrace(ex);
                            }
                            Controllers.dialog(message, LauncherHelper.this.scriptFile == null ? I18n.i18n("launch.failed") : I18n.i18n("version.launch_script.failed"), MessageDialogPane.MessageType.ERROR);
                        }
                    }
                    LauncherHelper.this.launchingStepsPane.setExecutor(null);
                });
            }
        });
        executor.start();
    }

    private static void checkGameState(Profile profile, VersionSetting setting, Version version, Runnable onAccept) throws InterruptedException {
        Optional<JavaVersion> java8;
        if (setting.isNotCheckJVM()) {
            onAccept.run();
            return;
        }
        boolean flag = false;
        boolean java8required = false;
        boolean newJavaRequired = false;
        VersionNumber gameVersion = VersionNumber.asVersion(GameVersion.minecraftVersion(profile.getRepository().getVersionJar(version)).orElse("Unknown"));
        JavaVersion java = setting.getJavaVersion();
        if (java == null) {
            Controllers.dialog(I18n.i18n("launch.wrong_javadir"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, onAccept);
            setting.setJava(null);
            setting.setDefaultJavaPath(null);
            java = JavaVersion.fromCurrentEnvironment();
            flag = true;
        }
        if (!flag && java.getParsedVersion() < 80 && gameVersion.compareTo(VersionNumber.asVersion("1.7.2")) > 0) {
            java8 = JavaVersion.getJavas().stream().filter(javaVersion -> javaVersion.getParsedVersion() >= 80).max(Comparator.comparing(JavaVersion::getVersionNumber));
            if (java8.isPresent()) {
                newJavaRequired = true;
                setting.setJavaVersion(java8.get());
            } else {
                if (gameVersion.compareTo(VersionNumber.asVersion("1.13")) >= 0) {
                    Controllers.dialog(I18n.i18n("launch.advice.java8_1_13"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, null);
                } else {
                    Controllers.dialog(I18n.i18n("launch.advice.newer_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, onAccept);
                }
                flag = true;
            }
        }
        if (!flag && java.getParsedVersion() >= 90 && version.getMainClass().equals("net.minecraft.launchwrapper.Launch") && version.getLibraries().stream().filter(library -> "launchwrapper".equals(library.getArtifactId())).anyMatch(library -> VersionNumber.asVersion(library.getVersion()).compareTo(VersionNumber.asVersion("1.13")) < 0)) {
            java8 = JavaVersion.getJavas().stream().filter(javaVersion -> javaVersion.getParsedVersion() == 80).findAny();
            if (java8.isPresent()) {
                java8required = true;
                setting.setJavaVersion(java8.get());
                Controllers.dialog(I18n.i18n("launch.advice.java9") + "\n" + I18n.i18n("launch.advice.corrected"), I18n.i18n("message.info"), MessageDialogPane.MessageType.INFORMATION, onAccept);
                flag = true;
            } else {
                Controllers.dialog(I18n.i18n("launch.advice.java9") + "\n" + I18n.i18n("launch.advice.uncorrected"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, null);
                flag = true;
            }
        }
        VersionNumber JAVA_8 = VersionNumber.asVersion("1.8.0_51");
        if (!flag && gameVersion.compareTo(VersionNumber.asVersion("1.13")) >= 0 && java.getParsedVersion() == 80 && java.getVersionNumber().compareTo(JAVA_8) < 0) {
            Optional<JavaVersion> java82 = JavaVersion.getJavas().stream().filter(javaVersion -> javaVersion.getVersionNumber().compareTo(JAVA_8) >= 0).max(Comparator.comparing(JavaVersion::getVersionNumber));
            if (java82.isPresent()) {
                newJavaRequired = true;
                setting.setJavaVersion(java82.get());
            } else {
                Controllers.dialog(I18n.i18n("launch.advice.java8_51_1_13"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, onAccept);
                flag = true;
            }
        }
        if (!flag && java.getPlatform() == org.jackhuang.hmcl.util.platform.Platform.BIT_32 && org.jackhuang.hmcl.util.platform.Platform.IS_64_BIT) {
            JavaVersion java32 = java;
            Optional<JavaVersion> java64 = JavaVersion.getJavas().stream().filter(javaVersion -> javaVersion.getPlatform() == org.jackhuang.hmcl.util.platform.Platform.PLATFORM).filter(javaVersion -> javaVersion.getParsedVersion() == java32.getParsedVersion()).max(Comparator.comparing(JavaVersion::getVersionNumber));
            if (!java64.isPresent()) {
                boolean java8requiredFinal = java8required;
                boolean newJavaRequiredFinal = newJavaRequired;
                java64 = JavaVersion.getJavas().stream().filter(javaVersion -> javaVersion.getPlatform() == org.jackhuang.hmcl.util.platform.Platform.PLATFORM).filter(javaVersion -> {
                    if (java8requiredFinal) {
                        return javaVersion.getParsedVersion() == 80;
                    }
                    if (newJavaRequiredFinal) {
                        return javaVersion.getParsedVersion() >= 80;
                    }
                    return true;
                }).max(Comparator.comparing(JavaVersion::getVersionNumber));
            }
            if (java64.isPresent()) {
                setting.setJavaVersion(java64.get());
            } else {
                Controllers.dialog(I18n.i18n("launch.advice.different_platform"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, onAccept);
                flag = true;
            }
        }
        if (!flag && java.getPlatform() == org.jackhuang.hmcl.util.platform.Platform.BIT_32 && (double)setting.getMaxMemory() > 1536.0) {
            Controllers.confirm(I18n.i18n("launch.advice.too_large_memory_for_32bit"), I18n.i18n("message.error"), onAccept, null);
            flag = true;
        }
        if (!flag && OperatingSystem.TOTAL_MEMORY > 0 && OperatingSystem.TOTAL_MEMORY < setting.getMaxMemory()) {
            Controllers.confirm(I18n.i18n("launch.advice.not_enough_space", OperatingSystem.TOTAL_MEMORY), I18n.i18n("message.error"), onAccept, null);
            flag = true;
        }
        if (!flag) {
            boolean hasForge2760 = version.getLibraries().stream().filter(it -> it.is("net.minecraftforge", "forge")).anyMatch(it -> VersionNumber.VERSION_COMPARATOR.compare("1.12.2-14.23.5.2760", it.getVersion()) <= 0 && VersionNumber.VERSION_COMPARATOR.compare(it.getVersion(), "1.12.2-14.23.5.2773") < 0);
            boolean hasLiteLoader = version.getLibraries().stream().anyMatch(it -> it.is("com.mumfrey", "liteloader"));
            if (hasForge2760 && hasLiteLoader && gameVersion.compareTo(VersionNumber.asVersion("1.12.2")) == 0) {
                Controllers.confirm(I18n.i18n("launch.advice.forge2760_liteloader"), I18n.i18n("message.error"), onAccept, null);
                flag = true;
            }
        }
        if (!flag) {
            boolean hasForge28_2_2 = version.getLibraries().stream().filter(it -> it.is("net.minecraftforge", "forge")).anyMatch(it -> VersionNumber.VERSION_COMPARATOR.compare("1.14.4-28.2.2", it.getVersion()) <= 0);
            boolean hasOptiFine = version.getLibraries().stream().anyMatch(it -> it.is("optifine", "OptiFine"));
            if (hasForge28_2_2 && hasOptiFine && gameVersion.compareTo(VersionNumber.asVersion("1.14.4")) == 0) {
                Controllers.confirm(I18n.i18n("launch.advice.forge28_2_2_optifine"), I18n.i18n("message.error"), onAccept, null);
                flag = true;
            }
        }
        if (!flag) {
            onAccept.run();
        }
    }

    private void checkExit() {
        switch (this.launcherVisibility) {
            case HIDE_AND_REOPEN: {
                Platform.runLater(() -> Optional.ofNullable(Controllers.getStage()).ifPresent(Stage::show));
                break;
            }
            case KEEP: {
                break;
            }
            case CLOSE: {
                throw new Error("Never get to here");
            }
            case HIDE: {
                Platform.runLater(() -> {
                    Platform.setImplicitExit((boolean)true);
                    Launcher.stopWithoutPlatform();
                });
            }
        }
    }

    public static void stopManagedProcesses() {
        while (!PROCESSES.isEmpty()) {
            Optional.ofNullable(PROCESSES.poll()).ifPresent(ManagedProcess::stop);
        }
    }

    class HMCLProcessListener
    implements ProcessListener {
        private final HMCLGameRepository repository;
        private final String version;
        private final Map<String, String> forbiddenTokens;
        private ManagedProcess process;
        private boolean lwjgl;
        private LogWindow logWindow;
        private final boolean detectWindow;
        private final LinkedList<Pair<String, Log4jLevel>> logs;
        private final CountDownLatch logWindowLatch = new CountDownLatch(1);
        private final CountDownLatch launchingLatch;

        public HMCLProcessListener(HMCLGameRepository repository, String version, AuthInfo authInfo, CountDownLatch launchingLatch, boolean detectWindow) {
            this.repository = repository;
            this.version = version;
            this.launchingLatch = launchingLatch;
            this.detectWindow = detectWindow;
            this.forbiddenTokens = authInfo == null ? Collections.emptyMap() : Lang.mapOf(Pair.pair(authInfo.getAccessToken(), "<access token>"), Pair.pair(UUIDTypeAdapter.fromUUID(authInfo.getUUID()), "<uuid>"), Pair.pair(authInfo.getUsername(), "<player>"));
            this.logs = new LinkedList();
        }

        @Override
        public void setProcess(ManagedProcess process) {
            this.process = process;
            String command = new CommandBuilder().addAll(process.getCommands()).toString();
            for (Map.Entry<String, String> entry : this.forbiddenTokens.entrySet()) {
                command = command.replace(entry.getKey(), entry.getValue());
            }
            Logging.LOG.info("Launched process: " + command);
            if (LauncherHelper.this.showLogs) {
                Platform.runLater(() -> {
                    this.logWindow = new LogWindow();
                    this.logWindow.show();
                    this.logWindowLatch.countDown();
                });
            }
        }

        private void finishLaunch() {
            switch (LauncherHelper.this.launcherVisibility) {
                case HIDE_AND_REOPEN: {
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().hide();
                            this.launchingLatch.countDown();
                        }
                    });
                    break;
                }
                case CLOSE: {
                    break;
                }
                case KEEP: {
                    Platform.runLater(this.launchingLatch::countDown);
                    break;
                }
                case HIDE: {
                    this.launchingLatch.countDown();
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().close();
                            Controllers.shutdown();
                            Schedulers.shutdown();
                        }
                    });
                }
            }
        }

        @Override
        public synchronized void onLog(String log, Log4jLevel level) {
            String newLog = log;
            for (Map.Entry<String, String> entry : this.forbiddenTokens.entrySet()) {
                newLog = newLog.replace(entry.getKey(), entry.getValue());
            }
            String filteredLog = newLog;
            if (level.lessOrEqual(Log4jLevel.ERROR)) {
                System.err.println(filteredLog);
            } else {
                System.out.println(filteredLog);
            }
            this.logs.add(Pair.pair(filteredLog, level));
            if (this.logs.size() > ConfigHolder.config().getLogLines()) {
                this.logs.removeFirst();
            }
            if (LauncherHelper.this.showLogs) {
                try {
                    this.logWindowLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                Platform.runLater(() -> this.logWindow.logLine(filteredLog, level));
            }
            if (!this.lwjgl && (filteredLog.toLowerCase().contains("lwjgl version") || filteredLog.toLowerCase().contains("lwjgl openal") || !this.detectWindow)) {
                this.lwjgl = true;
                this.finishLaunch();
            }
        }

        @Override
        public void onExit(int exitCode, ProcessListener.ExitType exitType) {
            this.launchingLatch.countDown();
            if (exitType == ProcessListener.ExitType.INTERRUPTED) {
                return;
            }
            if (!this.lwjgl) {
                this.finishLaunch();
            }
            if (exitType != ProcessListener.ExitType.NORMAL) {
                this.repository.markVersionLaunchedAbnormally(this.version);
                Platform.runLater(() -> {
                    if (this.logWindow == null) {
                        this.logWindow = new LogWindow();
                        switch (exitType) {
                            case JVM_ERROR: {
                                this.logWindow.setTitle(I18n.i18n("launch.failed.cannot_create_jvm"));
                                break;
                            }
                            case APPLICATION_ERROR: {
                                this.logWindow.setTitle(I18n.i18n("launch.failed.exited_abnormally"));
                            }
                        }
                        this.logWindow.logLine("Command: " + new CommandBuilder().addAll(this.process.getCommands()).toString(), Log4jLevel.INFO);
                        for (Map.Entry entry : this.logs) {
                            this.logWindow.logLine((String)entry.getKey(), (Log4jLevel)((Object)((Object)entry.getValue())));
                        }
                    }
                    this.logWindow.showGameCrashReport();
                });
            }
            LauncherHelper.this.checkExit();
        }
    }
}

