/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureModel;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.ResourceNotFoundError;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public final class TexturesLoader {
    private static final ThreadPoolExecutor POOL = Lang.threadPool("TexturesDownload", true, 2, 10L, TimeUnit.SECONDS);
    private static final Path TEXTURES_DIR = Metadata.MINECRAFT_DIRECTORY.resolve("assets").resolve("skins");
    private static final Map<TextureModel, LoadedTexture> DEFAULT_SKINS = new EnumMap<TextureModel, LoadedTexture>(TextureModel.class);

    private TexturesLoader() {
    }

    private static Path getTexturePath(Texture texture) {
        String hash;
        String url = texture.getUrl();
        int slash = url.lastIndexOf(47);
        int dot = url.lastIndexOf(46);
        if (dot < slash) {
            dot = url.length();
        }
        String prefix = (hash = url.substring(slash + 1, dot)).length() > 2 ? hash.substring(0, 2) : "xx";
        return TEXTURES_DIR.resolve(prefix).resolve(hash);
    }

    public static LoadedTexture loadTexture(Texture texture) throws IOException {
        BufferedImage img;
        if (StringUtils.isBlank(texture.getUrl())) {
            throw new IOException("Texture url is empty");
        }
        Path file = TexturesLoader.getTexturePath(texture);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            try {
                new FileDownloadTask(new URL(texture.getUrl()), file.toFile()).run();
                Logging.LOG.info("Texture downloaded: " + texture.getUrl());
            }
            catch (Exception e) {
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    Logging.LOG.log(Level.WARNING, "Failed to download texture " + texture.getUrl() + ", but the file is available", e);
                }
                throw new IOException("Failed to download texture " + texture.getUrl());
            }
        }
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            img = ImageIO.read(in);
        }
        if (img == null) {
            throw new IOException("Texture is malformed");
        }
        Map<String, String> metadata = texture.getMetadata();
        if (metadata == null) {
            metadata = Collections.emptyMap();
        }
        return new LoadedTexture(img, metadata);
    }

    private static void loadDefaultSkin(String path, TextureModel model) {
        try (InputStream in = ResourceNotFoundError.getResourceAsStream(path);){
            DEFAULT_SKINS.put(model, new LoadedTexture(ImageIO.read(in), Collections.singletonMap("model", model.modelName)));
        }
        catch (Throwable e) {
            throw new ResourceNotFoundError("Cannoot load default skin from " + path, e);
        }
    }

    public static LoadedTexture getDefaultSkin(TextureModel model) {
        return DEFAULT_SKINS.get((Object)model);
    }

    public static ObjectBinding<LoadedTexture> skinBinding(YggdrasilService service, UUID uuid) {
        LoadedTexture uuidFallback = TexturesLoader.getDefaultSkin(TextureModel.detectUUID(uuid));
        return BindingMapping.of(service.getProfileRepository().binding(uuid)).map(profile -> profile.flatMap(it -> {
            try {
                return YggdrasilService.getTextures(it);
            }
            catch (ServerResponseMalformedException e) {
                Logging.LOG.log(Level.WARNING, "Failed to parse texture payload", e);
                return Optional.empty();
            }
        }).flatMap(it -> Optional.ofNullable(it.get((Object)TextureType.SKIN))).filter(it -> StringUtils.isNotBlank(it.getUrl()))).asyncMap(it -> {
            if (it.isPresent()) {
                Texture texture = (Texture)it.get();
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return TexturesLoader.loadTexture(texture);
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to load texture " + texture.getUrl() + ", using fallback texture", e);
                        return uuidFallback;
                    }
                }, POOL);
            }
            return CompletableFuture.completedFuture(uuidFallback);
        }, uuidFallback);
    }

    public static ObjectBinding<LoadedTexture> skinBinding(Account account) {
        LoadedTexture uuidFallback = TexturesLoader.getDefaultSkin(TextureModel.detectUUID(account.getUUID()));
        return BindingMapping.of(account.getTextures()).map(textures -> textures.flatMap(it -> Optional.ofNullable(it.get((Object)TextureType.SKIN))).filter(it -> StringUtils.isNotBlank(it.getUrl()))).asyncMap(it -> {
            if (it.isPresent()) {
                Texture texture = (Texture)it.get();
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return TexturesLoader.loadTexture(texture);
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to load texture " + texture.getUrl() + ", using fallback texture", e);
                        return uuidFallback;
                    }
                }, POOL);
            }
            return CompletableFuture.completedFuture(uuidFallback);
        }, uuidFallback);
    }

    public static BufferedImage toAvatar(BufferedImage skin, int size) {
        BufferedImage avatar = new BufferedImage(size, size, 2);
        Graphics2D g = avatar.createGraphics();
        int scale = skin.getWidth() / 64;
        int faceOffset = (int)Math.round((double)size / 18.0);
        g.drawImage(skin, faceOffset, faceOffset, size - faceOffset, size - faceOffset, 8 * scale, 8 * scale, 16 * scale, 16 * scale, null);
        g.drawImage(skin, 0, 0, size, size, 40 * scale, 8 * scale, 48 * scale, 16 * scale, null);
        g.dispose();
        return avatar;
    }

    public static ObjectBinding<Image> fxAvatarBinding(YggdrasilService service, UUID uuid, int size) {
        return BindingMapping.of(TexturesLoader.skinBinding(service, uuid)).map(it -> TexturesLoader.toAvatar(((LoadedTexture)it).image, size)).map(img -> SwingFXUtils.toFXImage((BufferedImage)img, null));
    }

    public static ObjectBinding<Image> fxAvatarBinding(Account account, int size) {
        if (account instanceof YggdrasilAccount || account instanceof MicrosoftAccount) {
            return BindingMapping.of(TexturesLoader.skinBinding(account)).map(it -> TexturesLoader.toAvatar(((LoadedTexture)it).image, size)).map(img -> SwingFXUtils.toFXImage((BufferedImage)img, null));
        }
        return Bindings.createObjectBinding(() -> SwingFXUtils.toFXImage((BufferedImage)TexturesLoader.toAvatar(TexturesLoader.getDefaultSkin(TextureModel.detectUUID(account.getUUID())).image, size), null), (Observable[])new Observable[0]);
    }

    static {
        TexturesLoader.loadDefaultSkin("/assets/img/steve.png", TextureModel.STEVE);
        TexturesLoader.loadDefaultSkin("/assets/img/alex.png", TextureModel.ALEX);
    }

    public static class LoadedTexture {
        private final BufferedImage image;
        private final Map<String, String> metadata;

        public LoadedTexture(BufferedImage image, Map<String, String> metadata) {
            this.image = Objects.requireNonNull(image);
            this.metadata = Objects.requireNonNull(metadata);
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

