/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.StringArgument;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.CommandBuilder;

public final class VersionLibraryBuilder {
    private final Version version;
    private final List<String> mcArgs;
    private final List<Argument> game;
    private final List<Argument> jvm;
    private final List<Library> libraries;
    private final boolean useMcArgs;
    private boolean jvmChanged = false;

    public VersionLibraryBuilder(Version version) {
        this.version = version;
        this.libraries = new ArrayList<Library>(version.getLibraries());
        this.mcArgs = version.getMinecraftArguments().map(StringUtils::tokenize).map(ArrayList::new).orElse(null);
        this.game = version.getArguments().map(Arguments::getGame).map(ArrayList::new).orElseGet(ArrayList::new);
        this.jvm = new ArrayList<Argument>((Collection)version.getArguments().map(Arguments::getJvm).orElse(Arguments.DEFAULT_JVM_ARGUMENTS));
        this.useMcArgs = this.mcArgs != null;
    }

    public Version build() {
        Version ret = this.version;
        if (this.useMcArgs) {
            ret = ret.setMinecraftArguments(new CommandBuilder().addAllWithoutParsing(this.mcArgs).toString());
        }
        return ret.setArguments(ret.getArguments().map(args -> args.withGame(this.game)).map(args -> this.jvmChanged ? args.withJvm(this.jvm) : args).orElse(new Arguments(this.game, this.jvmChanged ? this.jvm : null))).setLibraries(this.libraries);
    }

    public void removeTweakClass(String target) {
        this.replaceTweakClass(target, null, false);
    }

    public void replaceTweakClass(String target, String replacement) {
        this.replaceTweakClass(target, replacement, true);
    }

    public void addTweakClass(String target, String replacement) {
        this.replaceTweakClass(target, replacement, false);
    }

    public void replaceTweakClass(String target, String replacement, boolean inPlace) {
        int i;
        if (replacement == null && inPlace) {
            throw new IllegalArgumentException("Replacement cannot be null in replace mode");
        }
        boolean replaced = false;
        if (this.useMcArgs) {
            i = 0;
            while (i + 1 < this.mcArgs.size()) {
                String arg0Str = this.mcArgs.get(i);
                String arg1Str = this.mcArgs.get(i + 1);
                if (arg0Str.equals("--tweakClass") && arg1Str.toLowerCase().contains(target)) {
                    if (!replaced && inPlace) {
                        this.mcArgs.set(i + 1, replacement);
                        replaced = true;
                    } else {
                        this.mcArgs.remove(i);
                        this.mcArgs.remove(i);
                        --i;
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i + 1 < this.game.size()) {
            Argument arg0 = this.game.get(i);
            Argument arg1 = this.game.get(i + 1);
            if (arg0 instanceof StringArgument && arg1 instanceof StringArgument) {
                String arg0Str = arg0.toString();
                String arg1Str = arg1.toString();
                if (arg0Str.equals("--tweakClass") && arg1Str.toLowerCase().contains(target)) {
                    if (!replaced && inPlace) {
                        this.game.set(i + 1, new StringArgument(replacement));
                        replaced = true;
                    } else {
                        this.game.remove(i);
                        this.game.remove(i);
                        --i;
                    }
                }
            }
            ++i;
        }
        if (!replaced && replacement != null) {
            this.game.add(new StringArgument("--tweakClass"));
            this.game.add(new StringArgument(replacement));
        }
    }

    public void addGameArgument(String ... args) {
        for (String arg : args) {
            this.game.add(new StringArgument(arg));
        }
    }

    public void addJvmArgument(String ... args) {
        this.jvmChanged = true;
        for (String arg : args) {
            this.jvm.add(new StringArgument(arg));
        }
    }

    public void addLibrary(Library library) {
        this.libraries.add(library);
    }
}

