/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.io.Zipper;

public class World {
    private final Path file;
    private String fileName;
    private String worldName;
    private String gameVersion;
    private long lastPlayed;

    public World(Path file) throws IOException {
        this.file = file;
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.loadFromDirectory();
        } else if (Files.isRegularFile(file, new LinkOption[0])) {
            this.loadFromZip();
        } else {
            throw new IOException("Path " + file + " cannot be recognized as a Minecraft world");
        }
    }

    private void loadFromDirectory() throws IOException {
        this.fileName = FileUtils.getName(this.file);
        Path levelDat = this.file.resolve("level.dat");
        this.getWorldName(levelDat);
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    private void loadFromZipImpl(Path root) throws IOException {
        Path levelDat = root.resolve("level.dat");
        if (!Files.exists(levelDat, new LinkOption[0])) {
            throw new IOException("Not a valid world zip file since level.dat cannot be found.");
        }
        this.getWorldName(levelDat);
    }

    private void loadFromZip() throws IOException {
        try (FileSystem fs = CompressingUtils.readonly(this.file).setAutoDetectEncoding(true).build();){
            Path cur = fs.getPath("/level.dat", new String[0]);
            if (Files.isRegularFile(cur, new LinkOption[0])) {
                this.fileName = FileUtils.getName(this.file);
                this.loadFromZipImpl(fs.getPath("/", new String[0]));
                return;
            }
            try (Stream<Path> stream = Files.list(fs.getPath("/", new String[0]));){
                Path root = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().orElseThrow(() -> new IOException("Not a valid world zip file"));
                this.fileName = FileUtils.getName(root);
                this.loadFromZipImpl(root);
            }
        }
    }

    private void getWorldName(Path levelDat) throws IOException {
        CompoundTag version;
        CompoundTag nbt = World.parseLevelDat(levelDat);
        CompoundTag data = (CompoundTag)nbt.get("Data");
        if (data == null) {
            throw new IOException("level.dat missing Data");
        }
        if (!(data.get("LevelName") instanceof StringTag)) {
            throw new IOException("level.dat missing LevelName");
        }
        this.worldName = ((StringTag)data.get("LevelName")).getValue();
        if (!(data.get("LastPlayed") instanceof LongTag)) {
            throw new IOException("level.dat missing LastPlayed");
        }
        this.lastPlayed = ((LongTag)data.get("LastPlayed")).getValue();
        this.gameVersion = null;
        if (data.get("Version") instanceof CompoundTag && (version = (CompoundTag)data.get("Version")).get("Name") instanceof StringTag) {
            this.gameVersion = ((StringTag)version.get("Name")).getValue();
        }
    }

    public void rename(String newName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        Path levelDat = this.file.resolve("level.dat");
        CompoundTag nbt = World.parseLevelDat(levelDat);
        CompoundTag data = (CompoundTag)nbt.get("Data");
        data.put(new StringTag("LevelName", newName));
        try (GZIPOutputStream os = new GZIPOutputStream(Files.newOutputStream(levelDat, new OpenOption[0]));){
            NBTIO.writeTag(os, (Tag)nbt);
        }
        Files.move(this.file, this.file.resolveSibling(newName), new CopyOption[0]);
    }

    public void install(Path savesDir, String name) throws IOException {
        Path worldDir;
        try {
            worldDir = savesDir.resolve(name);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        if (Files.isDirectory(worldDir, new LinkOption[0])) {
            throw new FileAlreadyExistsException("World already exists");
        }
        if (Files.isRegularFile(this.file, new LinkOption[0])) {
            block32: {
                try (FileSystem fs = CompressingUtils.readonly(this.file).setAutoDetectEncoding(true).build();){
                    Path cur = fs.getPath("/level.dat", new String[0]);
                    if (Files.isRegularFile(cur, new LinkOption[0])) {
                        this.fileName = FileUtils.getName(this.file);
                        new Unzipper(this.file, worldDir).unzip();
                        break block32;
                    }
                    try (Stream<Path> stream = Files.list(fs.getPath("/", new String[0]));){
                        List subDirs = stream.collect(Collectors.toList());
                        if (subDirs.size() != 1) {
                            throw new IOException("World zip malformed");
                        }
                        String subDirectoryName = FileUtils.getName((Path)subDirs.get(0));
                        new Unzipper(this.file, worldDir).setSubDirectory("/" + subDirectoryName + "/").unzip();
                    }
                }
            }
            new World(worldDir).rename(name);
        } else if (Files.isDirectory(this.file, new LinkOption[0])) {
            FileUtils.copyDirectory(this.file, worldDir);
        }
    }

    public void export(Path zip, String worldName) throws IOException {
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            throw new IOException();
        }
        try (Zipper zipper = new Zipper(zip);){
            zipper.putDirectory(this.file, "/" + worldName + "/");
        }
    }

    private static CompoundTag parseLevelDat(Path path) throws IOException {
        Throwable throwable = null;
        try (BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])));){
            Tag nbt = NBTIO.readTag(is);
            if (nbt instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt;
                return compoundTag;
            }
            try {
                throw new IOException("level.dat malformed");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static Stream<World> getWorlds(Path savesDir) {
        try {
            if (Files.exists(savesDir, new LinkOption[0])) {
                return Files.list(savesDir).flatMap(world -> {
                    try {
                        return Stream.of(new World((Path)world));
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to read world " + world, e);
                        return Stream.empty();
                    }
                });
            }
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to read saves", e);
        }
        return Stream.empty();
    }
}

