/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hmcl.mod.ModInfo;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.IOUtils;

@Immutable
public final class LiteModMetadata {
    private final String name;
    private final String version;
    private final String mcversion;
    private final String revision;
    private final String author;
    private final String classTransformerClasses;
    private final String description;
    private final String modpackName;
    private final String modpackVersion;
    private final String checkUpdateUrl;
    private final String updateURI;

    public LiteModMetadata() {
        this("", "", "", "", "", "", "", "", "", "", "");
    }

    public LiteModMetadata(String name, String version, String mcversion, String revision, String author, String classTransformerClasses, String description, String modpackName, String modpackVersion, String checkUpdateUrl, String updateURI) {
        this.name = name;
        this.version = version;
        this.mcversion = mcversion;
        this.revision = revision;
        this.author = author;
        this.classTransformerClasses = classTransformerClasses;
        this.description = description;
        this.modpackName = modpackName;
        this.modpackVersion = modpackVersion;
        this.checkUpdateUrl = checkUpdateUrl;
        this.updateURI = updateURI;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGameVersion() {
        return this.mcversion;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getClassTransformerClasses() {
        return this.classTransformerClasses;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModpackName() {
        return this.modpackName;
    }

    public String getModpackVersion() {
        return this.modpackVersion;
    }

    public String getCheckUpdateUrl() {
        return this.checkUpdateUrl;
    }

    public String getUpdateURI() {
        return this.updateURI;
    }

    public static ModInfo fromFile(ModManager modManager, File modFile) throws IOException, JsonParseException {
        try (ZipFile zipFile = new ZipFile(modFile);){
            ZipEntry entry = zipFile.getEntry("litemod.json");
            if (entry == null) {
                throw new IOException("File " + modFile + "is not a LiteLoader mod.");
            }
            LiteModMetadata metadata = JsonUtils.GSON.fromJson(IOUtils.readFullyAsString(zipFile.getInputStream(entry)), LiteModMetadata.class);
            if (metadata == null) {
                throw new IOException("Mod " + modFile + " `litemod.json` is malformed.");
            }
            ModInfo modInfo = new ModInfo(modManager, modFile, metadata.getName(), metadata.getDescription(), metadata.getAuthor(), metadata.getVersion(), metadata.getGameVersion(), metadata.getUpdateURI());
            return modInfo;
        }
    }
}

