/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class MinecraftInstanceTask<T>
extends Task<ModpackConfiguration<T>> {
    private final File zipFile;
    private final Charset encoding;
    private final String subDirectory;
    private final File jsonFile;
    private final T manifest;
    private final String type;
    private final String name;
    private final String version;

    public MinecraftInstanceTask(File zipFile, Charset encoding, String subDirectory, T manifest, String type, String name, String version, File jsonFile) {
        this.zipFile = zipFile;
        this.encoding = encoding;
        this.subDirectory = FileUtils.normalizePath(subDirectory);
        this.manifest = manifest;
        this.jsonFile = jsonFile;
        this.type = type;
        this.name = name;
        this.version = version;
    }

    @Override
    public void execute() throws Exception {
        final LinkedList<ModpackConfiguration.FileInformation> overrides = new LinkedList<ModpackConfiguration.FileInformation>();
        try (FileSystem fs = CompressingUtils.readonly(this.zipFile.toPath()).setEncoding(this.encoding).build();){
            final Path root = fs.getPath(this.subDirectory, new String[0]);
            if (Files.exists(root, new LinkOption[0])) {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String relativePath = root.relativize(file).normalize().toString().replace(File.separatorChar, '/');
                        overrides.add(new ModpackConfiguration.FileInformation(relativePath, Hex.encodeHex(DigestUtils.digest("SHA-1", file))));
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        ModpackConfiguration<T> configuration = new ModpackConfiguration<T>(this.manifest, this.type, this.name, this.version, overrides);
        FileUtils.writeText(this.jsonFile, JsonUtils.GSON.toJson(configuration));
        this.setResult(configuration);
    }
}

