/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class ModInfo
implements Comparable<ModInfo> {
    private Path file;
    private final String name;
    private final String description;
    private final String authors;
    private final String version;
    private final String gameVersion;
    private final String url;
    private final String fileName;
    private final BooleanProperty activeProperty;

    public ModInfo(ModManager modManager, File file, String name, String description) {
        this(modManager, file, name, description, "", "", "", "");
    }

    public ModInfo(final ModManager modManager, File file, String name, String description, String authors, String version, String gameVersion, String url) {
        this.file = file.toPath();
        this.name = name;
        this.description = description;
        this.authors = authors;
        this.version = version;
        this.gameVersion = gameVersion;
        this.url = url;
        this.activeProperty = new SimpleBooleanProperty(this, "active", !modManager.isDisabled(file)){

            protected void invalidated() {
                Path path = ModInfo.this.file.toAbsolutePath();
                try {
                    if (this.get()) {
                        ModInfo.this.file = modManager.enableMod(path);
                    } else {
                        ModInfo.this.file = modManager.disableMod(path);
                    }
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.SEVERE, "Unable to invert state of mod file " + path, e);
                }
            }
        };
        this.fileName = StringUtils.substringBeforeLast(this.isActive() ? file.getName() : FileUtils.getNameWithoutExtension(file), '.');
    }

    public Path getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public BooleanProperty activeProperty() {
        return this.activeProperty;
    }

    public boolean isActive() {
        return this.activeProperty.get();
    }

    public void setActive(boolean active) {
        this.activeProperty.set(active);
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int compareTo(ModInfo o) {
        return this.getFileName().compareTo(o.getFileName());
    }

    public boolean equals(Object obj) {
        return obj instanceof ModInfo && Objects.equals(this.getFileName(), ((ModInfo)obj).getFileName());
    }

    public int hashCode() {
        return Objects.hash(this.getFileName());
    }
}

