/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.TreeSet;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.mod.FabricModMetadata;
import org.jackhuang.hmcl.mod.ForgeModMetadata;
import org.jackhuang.hmcl.mod.LiteModMetadata;
import org.jackhuang.hmcl.mod.ModInfo;
import org.jackhuang.hmcl.mod.PackMcMeta;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class ModManager {
    private final GameRepository repository;
    private final String id;
    private final TreeSet<ModInfo> modInfos = new TreeSet();
    private boolean loaded = false;
    public static final String DISABLED_EXTENSION = ".disabled";

    public ModManager(GameRepository repository, String id) {
        this.repository = repository;
        this.id = id;
    }

    public GameRepository getRepository() {
        return this.repository;
    }

    public String getVersion() {
        return this.id;
    }

    private Path getModsDirectory() {
        return this.repository.getRunDirectory(this.id).toPath().resolve("mods");
    }

    private void addModInfo(File file) {
        try {
            this.modInfos.add(this.getModInfo(file));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public ModInfo getModInfo(File modFile) {
        String description;
        String extension;
        File file = this.isDisabled(modFile) ? new File(modFile.getAbsoluteFile().getParentFile(), FileUtils.getNameWithoutExtension(modFile)) : modFile;
        switch (extension = FileUtils.getExtension(file)) {
            case "zip": 
            case "jar": {
                try {
                    return ForgeModMetadata.fromFile(this, modFile);
                }
                catch (Exception exception) {
                    try {
                        return FabricModMetadata.fromFile(this, modFile);
                    }
                    catch (Exception exception2) {
                        try {
                            return PackMcMeta.fromFile(this, modFile);
                        }
                        catch (Exception exception3) {
                            description = "";
                            break;
                        }
                    }
                }
            }
            case "litemod": {
                try {
                    return LiteModMetadata.fromFile(this, modFile);
                }
                catch (Exception ignore) {
                    description = "LiteLoader Mod";
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("File " + modFile + " is not a mod file.");
            }
        }
        return new ModInfo(this, modFile, FileUtils.getNameWithoutExtension(modFile), description);
    }

    public void refreshMods() throws IOException {
        this.modInfos.clear();
        if (Files.isDirectory(this.getModsDirectory(), new LinkOption[0])) {
            try (DirectoryStream<Path> modsDirectoryStream = Files.newDirectoryStream(this.getModsDirectory());){
                for (Path subitem : modsDirectoryStream) {
                    if (Files.isDirectory(subitem, new LinkOption[0]) && VersionNumber.isIntVersionNumber(FileUtils.getName(subitem))) {
                        DirectoryStream<Path> subitemDirectoryStream = Files.newDirectoryStream(subitem);
                        Throwable throwable = null;
                        try {
                            for (Path subsubitem : subitemDirectoryStream) {
                                this.addModInfo(subsubitem.toFile());
                            }
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (subitemDirectoryStream == null) continue;
                            if (throwable != null) {
                                try {
                                    subitemDirectoryStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            subitemDirectoryStream.close();
                            continue;
                        }
                    }
                    this.addModInfo(subitem.toFile());
                }
            }
        }
        this.loaded = true;
    }

    public Collection<ModInfo> getMods() throws IOException {
        if (!this.loaded) {
            this.refreshMods();
        }
        return this.modInfos;
    }

    public void addMod(File file) throws IOException {
        File modsDirectory;
        if (!this.isFileMod(file)) {
            throw new IllegalArgumentException("File " + file + " is not a valid mod file.");
        }
        if (!this.loaded) {
            this.refreshMods();
        }
        if (!FileUtils.makeDirectory(modsDirectory = new File(this.repository.getRunDirectory(this.id), "mods"))) {
            throw new IOException("Cannot make directory " + modsDirectory);
        }
        File newFile = new File(modsDirectory, file.getName());
        FileUtils.copyFile(file, newFile);
        this.addModInfo(newFile);
    }

    public void removeMods(ModInfo ... modInfos) throws IOException {
        for (ModInfo modInfo : modInfos) {
            Files.deleteIfExists(modInfo.getFile());
        }
    }

    public Path disableMod(Path file) throws IOException {
        Path disabled = file.getParent().resolve(StringUtils.addSuffix(FileUtils.getName(file), DISABLED_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, disabled, StandardCopyOption.REPLACE_EXISTING);
        }
        return disabled;
    }

    public Path enableMod(Path file) throws IOException {
        Path enabled = file.getParent().resolve(StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, enabled, StandardCopyOption.REPLACE_EXISTING);
        }
        return enabled;
    }

    public boolean isDisabled(File file) {
        return file.getPath().endsWith(DISABLED_EXTENSION);
    }

    public boolean isFileMod(File file) {
        String name = file.getName();
        if (this.isDisabled(file)) {
            name = FileUtils.getNameWithoutExtension(file);
        }
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".litemod");
    }

    public boolean hasSimpleMod(String fileName) {
        return Files.exists(this.getModsDirectory().resolve(StringUtils.removeSuffix(fileName, DISABLED_EXTENSION)), new LinkOption[0]) || Files.exists(this.getModsDirectory().resolve(StringUtils.addSuffix(fileName, DISABLED_EXTENSION)), new LinkOption[0]);
    }

    public Path getSimpleModPath(String fileName) {
        return this.getModsDirectory().resolve(fileName);
    }
}

