/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jackhuang.hmcl.mod.ModInfo;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

@Immutable
public class PackMcMeta
implements Validation {
    @SerializedName(value="pack")
    private final PackInfo pack;

    public PackMcMeta() {
        this(new PackInfo());
    }

    public PackMcMeta(PackInfo packInfo) {
        this.pack = packInfo;
    }

    public PackInfo getPackInfo() {
        return this.pack;
    }

    @Override
    public void validate() throws JsonParseException {
        if (this.pack == null) {
            throw new JsonParseException("pack cannot be null");
        }
    }

    public static ModInfo fromFile(ModManager modManager, File modFile) throws IOException, JsonParseException {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(modFile.toPath());){
            Path mcmod = fs.getPath("pack.mcmeta", new String[0]);
            if (Files.notExists(mcmod, new LinkOption[0])) {
                throw new IOException("File " + modFile + " is not a resource pack.");
            }
            PackMcMeta metadata = JsonUtils.fromNonNullJson(FileUtils.readText(mcmod), PackMcMeta.class);
            ModInfo modInfo = new ModInfo(modManager, modFile, metadata.pack.description, "", "", "", "", "");
            return modInfo;
        }
    }

    public static class PackInfo {
        @SerializedName(value="pack_format")
        private final int packFormat;
        @SerializedName(value="description")
        private final String description;

        public PackInfo() {
            this(0, "");
        }

        public PackInfo(int packFormat, String description) {
            this.packFormat = packFormat;
            this.description = description;
        }

        public int getPackFormat() {
            return this.packFormat;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

