/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.net.URL;
import java.util.Objects;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.NetworkUtils;

@Immutable
public final class CurseManifestFile
implements Validation {
    @SerializedName(value="projectID")
    private final int projectID;
    @SerializedName(value="fileID")
    private final int fileID;
    @SerializedName(value="fileName")
    private final String fileName;
    @SerializedName(value="url")
    private final String url;
    @SerializedName(value="required")
    private final boolean required;

    public CurseManifestFile() {
        this(0, 0, null, null, true);
    }

    public CurseManifestFile(int projectID, int fileID, String fileName, String url, boolean required) {
        this.projectID = projectID;
        this.fileID = fileID;
        this.fileName = fileName;
        this.url = url;
        this.required = required;
    }

    public int getProjectID() {
        return this.projectID;
    }

    public int getFileID() {
        return this.fileID;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void validate() throws JsonParseException {
        if (this.projectID == 0 || this.fileID == 0) {
            throw new JsonParseException("Missing Project ID or File ID.");
        }
    }

    public URL getUrl() {
        return this.url == null ? NetworkUtils.toURL("https://www.curseforge.com/minecraft/mc-mods/" + this.projectID + "/download/" + this.fileID + "/file") : NetworkUtils.toURL(NetworkUtils.encodeLocation(this.url));
    }

    public CurseManifestFile withFileName(String fileName) {
        return new CurseManifestFile(this.projectID, this.fileID, fileName, this.url, this.required);
    }

    public CurseManifestFile withURL(String url) {
        return new CurseManifestFile(this.projectID, this.fileID, this.fileName, url, this.required);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurseManifestFile that = (CurseManifestFile)o;
        return this.projectID == that.projectID && this.fileID == that.fileID;
    }

    public int hashCode() {
        return Objects.hash(this.projectID, this.fileID);
    }
}

