/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;

@Immutable
public final class MultiMCInstancePatch {
    private final String name;
    private final String version;
    @SerializedName(value="mcVersion")
    private final String gameVersion;
    private final String mainClass;
    private final String fileId;
    @SerializedName(value="+tweakers")
    private final List<String> tweakers;
    @SerializedName(value="+libraries")
    private final List<Library> _libraries;
    @SerializedName(value="libraries")
    private final List<Library> libraries;

    public MultiMCInstancePatch() {
        this("", "", "", "", "", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public MultiMCInstancePatch(String name, String version, String gameVersion, String mainClass, String fileId, List<String> tweakers, List<Library> _libraries, List<Library> libraries) {
        this.name = name;
        this.version = version;
        this.gameVersion = gameVersion;
        this.mainClass = mainClass;
        this.fileId = fileId;
        this.tweakers = new ArrayList<String>(tweakers);
        this._libraries = new ArrayList<Library>(_libraries);
        this.libraries = new ArrayList<Library>(libraries);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getFileId() {
        return this.fileId;
    }

    public List<String> getTweakers() {
        return Collections.unmodifiableList(this.tweakers);
    }

    public List<Library> getLibraries() {
        return Lang.merge(this._libraries, this.libraries);
    }
}

