/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstanceConfiguration;
import org.jackhuang.hmcl.mod.multimc.MultiMCManifest;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.Zipper;

public class MultiMCModpackExportTask
extends Task<Void> {
    private final DefaultGameRepository repository;
    private final String versionId;
    private final List<String> whitelist;
    private final MultiMCInstanceConfiguration configuration;
    private final File output;
    public static final ModpackExportInfo.Options OPTION = new ModpackExportInfo.Options().requireMinMemory();

    public MultiMCModpackExportTask(DefaultGameRepository repository, String versionId, List<String> whitelist, MultiMCInstanceConfiguration configuration, File output) {
        this.repository = repository;
        this.versionId = versionId;
        this.whitelist = whitelist;
        this.configuration = configuration;
        this.output = output;
        this.onDone().register(event -> {
            if (event.isFailed()) {
                output.delete();
            }
        });
    }

    @Override
    public void execute() throws Exception {
        ArrayList<String> blackList = new ArrayList<String>(ModAdviser.MODPACK_BLACK_LIST);
        blackList.add(this.versionId + ".jar");
        blackList.add(this.versionId + ".json");
        Logging.LOG.info("Compressing game files without some files in blacklist, including files or directories: usernamecache.json, asm, logs, backups, versions, assets, usercache.json, libraries, crash-reports, launcher_profiles.json, NVIDIA, TCNodeTracker");
        try (Zipper zip = new Zipper(this.output.toPath());){
            zip.putDirectory(this.repository.getRunDirectory(this.versionId).toPath(), ".minecraft", path -> Modpack.acceptFile(path, blackList, this.whitelist));
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.repository.getResolvedPreservingPatchesVersion(this.versionId));
            String gameVersion = GameVersion.minecraftVersion(this.repository.getVersionJar(this.versionId)).orElseThrow(() -> new IOException("Cannot parse the version of " + this.versionId));
            ArrayList<MultiMCManifest.MultiMCManifestComponent> components = new ArrayList<MultiMCManifest.MultiMCManifestComponent>();
            components.add(new MultiMCManifest.MultiMCManifestComponent(true, false, "net.minecraft", gameVersion));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).ifPresent(forgeVersion -> components.add(new MultiMCManifest.MultiMCManifestComponent(false, false, "net.minecraftforge", (String)forgeVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.LITELOADER).ifPresent(liteLoaderVersion -> components.add(new MultiMCManifest.MultiMCManifestComponent(false, false, "com.mumfrey.liteloader", (String)liteLoaderVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC).ifPresent(fabricVersion -> components.add(new MultiMCManifest.MultiMCManifestComponent(false, false, "net.fabricmc.fabric-loader", (String)fabricVersion)));
            MultiMCManifest mmcPack = new MultiMCManifest(1, components);
            zip.putTextFile(JsonUtils.GSON.toJson(mmcPack), "mmc-pack.json");
            StringWriter writer = new StringWriter();
            this.configuration.toProperties().store(writer, "Auto generated by Hello Minecraft! Launcher");
            zip.putTextFile(writer.toString(), "instance.cfg");
            zip.putTextFile("", ".packignore");
        }
    }
}

