/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.server;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public class ServerModpackLocalInstallTask
extends Task<Void> {
    private final File zipFile;
    private final Modpack modpack;
    private final ServerModpackManifest manifest;
    private final String name;
    private final DefaultGameRepository repository;
    private final List<Task<?>> dependencies = new LinkedList();
    private final List<Task<?>> dependents = new LinkedList();
    public static final String MODPACK_TYPE = "Server";

    public ServerModpackLocalInstallTask(DefaultDependencyManager dependencyManager, File zipFile, Modpack modpack, ServerModpackManifest manifest, String name) {
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.repository = dependencyManager.getGameRepository();
        File run = this.repository.getRunDirectory(name);
        File json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && !json.exists()) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        GameBuilder builder = dependencyManager.gameBuilder().name(name);
        for (ServerModpackManifest.Addon addon : manifest.getAddons()) {
            builder.version(addon.getId(), addon.getVersion());
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            if (event.isFailed()) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration config = null;
        try {
            if (json.exists() && !MODPACK_TYPE.equals((config = (ModpackConfiguration)JsonUtils.GSON.fromJson(FileUtils.readText(json), new TypeToken<ModpackConfiguration<ServerModpackManifest>>(){}.getType())).getType())) {
                throw new IllegalArgumentException("Version " + name + " is not a Server modpack. Cannot update this version.");
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
        this.dependents.add(new ModpackInstallTask(zipFile, run, modpack.getEncoding(), "/overrides", any -> true, config).withStage("hmcl.modpack"));
        this.dependents.add(new MinecraftInstanceTask<ServerModpackManifest>(zipFile, modpack.getEncoding(), "/overrides", manifest, MODPACK_TYPE, modpack.getName(), modpack.getVersion(), this.repository.getModpackConfiguration(name)).withStage("hmcl.modpack"));
    }

    @Override
    public List<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
    }

    @Override
    public List<String> getStages() {
        return Stream.concat(this.dependents.stream().flatMap(task -> task.getStages().stream()), Stream.of("hmcl.modpack")).collect(Collectors.toList());
    }
}

