/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.ConfigUpgrader;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.util.InvocationDispatcher;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class ConfigHolder {
    public static final String CONFIG_FILENAME = "hmcl.json";
    public static final String CONFIG_FILENAME_LINUX = ".hmcl.json";
    private static Path configLocation;
    private static Config configInstance;
    private static boolean newlyCreated;
    private static InvocationDispatcher<String> configWriter;

    private ConfigHolder() {
    }

    public static Config config() {
        if (configInstance == null) {
            throw new IllegalStateException("Configuration hasn't been loaded");
        }
        return configInstance;
    }

    public static boolean isNewlyCreated() {
        return newlyCreated;
    }

    public static synchronized void init() throws IOException {
        if (configInstance != null) {
            throw new IllegalStateException("Configuration is already loaded");
        }
        configLocation = ConfigHolder.locateConfig();
        Logging.LOG.log(Level.INFO, "Config location: " + configLocation);
        configInstance = ConfigHolder.loadConfig();
        configInstance.addListener(source -> ConfigHolder.markConfigDirty());
        Settings.init();
        if (newlyCreated) {
            ConfigHolder.saveConfigSync();
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                try {
                    Files.setAttribute(configLocation, "dos:hidden", true, new LinkOption[0]);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to set hidden attribute of " + configLocation, e);
                }
            }
        }
        if (!Files.isWritable(configLocation)) {
            throw new IOException("Config at " + configLocation + " is not writable");
        }
    }

    private static Path locateConfig() {
        Path exePath = Paths.get("", new String[0]);
        try {
            Path jarPath = Paths.get(ConfigHolder.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath();
            if (Files.isRegularFile(jarPath, new LinkOption[0])) {
                exePath = jarPath = jarPath.getParent();
                Path config = jarPath.resolve(CONFIG_FILENAME);
                if (Files.isRegularFile(config, new LinkOption[0])) {
                    return config;
                }
                Path dotConfig = jarPath.resolve(CONFIG_FILENAME_LINUX);
                if (Files.isRegularFile(dotConfig, new LinkOption[0])) {
                    return dotConfig;
                }
            }
        }
        catch (Throwable jarPath) {
            // empty catch block
        }
        Path config = Paths.get(CONFIG_FILENAME, new String[0]);
        if (Files.isRegularFile(config, new LinkOption[0])) {
            return config;
        }
        Path dotConfig = Paths.get(CONFIG_FILENAME_LINUX, new String[0]);
        if (Files.isRegularFile(dotConfig, new LinkOption[0])) {
            return dotConfig;
        }
        return exePath.resolve(OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? CONFIG_FILENAME : CONFIG_FILENAME_LINUX);
    }

    private static Config loadConfig() throws IOException {
        if (Files.exists(configLocation, new LinkOption[0])) {
            try {
                String content = FileUtils.readText(configLocation);
                Config deserialized = Config.fromJson(content);
                if (deserialized != null) {
                    Map raw = new Gson().fromJson(content, Map.class);
                    ConfigUpgrader.upgradeConfig(deserialized, raw);
                    return deserialized;
                }
                Logging.LOG.info("Config is empty");
            }
            catch (JsonParseException e) {
                Logging.LOG.log(Level.WARNING, "Malformed config.", e);
            }
        }
        Logging.LOG.info("Creating an empty config");
        newlyCreated = true;
        return new Config();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToConfig(String content) throws IOException {
        Logging.LOG.info("Saving config");
        Path path = configLocation;
        synchronized (path) {
            Files.write(configLocation, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    static void markConfigDirty() {
        configWriter.accept(configInstance.toJson());
    }

    private static void saveConfigSync() throws IOException {
        ConfigHolder.writeToConfig(configInstance.toJson());
    }

    static {
        configWriter = InvocationDispatcher.runOn(Lang::thread, content -> {
            try {
                ConfigHolder.writeToConfig(content);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to save config", e);
            }
        });
    }
}

