/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import org.jackhuang.hmcl.task.CompletableFutureTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskCompletableFuture;
import org.jackhuang.hmcl.task.TaskEvent;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.function.ExceptionalRunnable;

public final class AsyncTaskExecutor
extends TaskExecutor {
    private CompletableFuture<Boolean> future;
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;

    public AsyncTaskExecutor(Task<?> task) {
        super(task);
    }

    @Override
    public TaskExecutor start() {
        this.taskListeners.forEach(TaskListener::onStart);
        this.future = ((CompletableFuture)this.executeTasks(null, Collections.singleton(this.firstTask)).thenApplyAsync(exception -> {
            boolean success;
            boolean bl = success = exception == null;
            if (!success) {
                Logging.LOG.log(Level.WARNING, "An exception occurred in task execution", (Throwable)exception);
                Throwable resolvedException = AsyncTaskExecutor.resolveException(exception);
                if (resolvedException instanceof RuntimeException && !(resolvedException instanceof CancellationException) && !(resolvedException instanceof JsonParseException) && !(resolvedException instanceof RejectedExecutionException) && uncaughtExceptionHandler != null) {
                    uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), resolvedException);
                }
            }
            this.taskListeners.forEach(it -> it.onStop(success, this));
            return success;
        })).exceptionally(e -> {
            Lang.handleUncaughtException(AsyncTaskExecutor.resolveException(e));
            return false;
        });
        return this;
    }

    @Override
    public boolean test() {
        this.start();
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
        }
        catch (CancellationException e) {
            Logging.LOG.log(Level.INFO, "Task " + this.firstTask + " has been cancelled.", e);
        }
        return false;
    }

    @Override
    public synchronized void cancel() {
        if (this.future == null) {
            throw new IllegalStateException("Cannot cancel a not started TaskExecutor");
        }
        this.cancelled.set(true);
        this.future.cancel(true);
    }

    private CompletableFuture<?> executeTasksExceptionally(Task<?> parentTask, Collection<Task<?>> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
            this.totTask.addAndGet(tasks.size());
            if (this.isCancelled()) {
                return CompletableFuture.runAsync(this::checkCancellation);
            }
            return CompletableFuture.allOf((CompletableFuture[])tasks.stream().map(task -> CompletableFuture.completedFuture(null).thenComposeAsync(unused2 -> this.executeTask(parentTask, (Task)task))).toArray(CompletableFuture[]::new));
        });
    }

    private CompletableFuture<Exception> executeTasks(Task<?> parentTask, Collection<Task<?>> tasks) {
        return ((CompletableFuture)this.executeTasksExceptionally(parentTask, tasks).thenApplyAsync(unused -> null)).exceptionally(throwable -> {
            Throwable resolved = AsyncTaskExecutor.resolveException(throwable);
            if (resolved instanceof Exception) {
                return (Exception)resolved;
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    private <T> CompletableFuture<T> executeCompletableFutureTask(Task<?> parentTask, final CompletableFutureTask<T> task) {
        this.checkCancellation();
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
            this.checkCancellation();
            task.setCancelled(this::isCancelled);
            task.setState(Task.TaskState.READY);
            if (parentTask != null && task.getStage() == null) {
                task.setStage(parentTask.getStage());
            }
            if (task.getSignificance().shouldLog()) {
                Logging.LOG.log(Level.FINE, "Executing task: " + task.getName());
            }
            this.taskListeners.forEach(it -> it.onReady(task));
            return task.getFuture(new TaskCompletableFuture(){

                public <T2> CompletableFuture<T2> one(Task<T2> subtask) {
                    return AsyncTaskExecutor.this.executeTask(task, subtask);
                }

                @Override
                public CompletableFuture<?> all(Collection<Task<?>> tasks) {
                    return AsyncTaskExecutor.this.executeTasksExceptionally(task, tasks);
                }
            });
        })).thenApplyAsync(result -> {
            this.checkCancellation();
            if (task.getSignificance().shouldLog()) {
                Logging.LOG.log(Level.FINER, "Task finished: " + task.getName());
            }
            task.setResult(result);
            task.onDone().fireEvent(new TaskEvent(this, task, false));
            this.taskListeners.forEach(it -> it.onFinished(task));
            task.setState(Task.TaskState.SUCCEEDED);
            return result;
        })).exceptionally(throwable -> {
            Throwable resolved = AsyncTaskExecutor.resolveException(throwable);
            if (resolved instanceof Exception) {
                Exception e = (Exception)resolved;
                if (e instanceof InterruptedException || e instanceof CancellationException) {
                    task.setException(null);
                    if (task.getSignificance().shouldLog()) {
                        Logging.LOG.log(Level.FINE, "Task aborted: " + task.getName());
                    }
                    task.onDone().fireEvent(new TaskEvent(this, task, true));
                    this.taskListeners.forEach(it -> it.onFailed(task, e));
                } else {
                    task.setException(e);
                    this.exception = e;
                    if (task.getSignificance().shouldLog()) {
                        Logging.LOG.log(Level.FINE, "Task failed: " + task.getName(), e);
                    }
                    task.onDone().fireEvent(new TaskEvent(this, task, true));
                    this.taskListeners.forEach(it -> it.onFailed(task, e));
                }
                task.setState(Task.TaskState.FAILED);
            }
            throw new CompletionException(resolved);
        });
    }

    private <T> CompletableFuture<T> executeNormalTask(Task<?> parentTask, Task<T> task) {
        this.checkCancellation();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
            this.checkCancellation();
            task.setCancelled(this::isCancelled);
            task.setState(Task.TaskState.READY);
            if (parentTask != null && task.getStage() == null) {
                task.setStage(parentTask.getStage());
            }
            if (task.getSignificance().shouldLog()) {
                Logging.LOG.log(Level.FINE, "Executing task: " + task.getName());
            }
            this.taskListeners.forEach(it -> it.onReady(task));
            if (task.doPreExecute()) {
                return CompletableFuture.runAsync(AsyncTaskExecutor.wrap(task::preExecute), task.getExecutor());
            }
            return CompletableFuture.completedFuture(null);
        })).thenComposeAsync(unused -> this.executeTasks(task, task.getDependents()))).thenComposeAsync(dependentsException -> {
            boolean isDependentsSucceeded;
            boolean bl = isDependentsSucceeded = dependentsException == null;
            if (!isDependentsSucceeded && task.isRelyingOnDependents()) {
                task.setException((Exception)dependentsException);
                AsyncTaskExecutor.rethrow(dependentsException);
            }
            if (isDependentsSucceeded) {
                task.setDependentsSucceeded();
            }
            return CompletableFuture.runAsync(AsyncTaskExecutor.wrap(() -> {
                task.setState(Task.TaskState.RUNNING);
                this.taskListeners.forEach(it -> it.onRunning(task));
                task.execute();
            }), task.getExecutor()).whenComplete((unused, throwable) -> {
                task.setState(Task.TaskState.EXECUTED);
                AsyncTaskExecutor.rethrow(throwable);
            });
        })).thenComposeAsync(unused -> this.executeTasks(task, task.getDependencies()))).thenComposeAsync(dependenciesException -> {
            boolean isDependenciesSucceeded;
            boolean bl = isDependenciesSucceeded = dependenciesException == null;
            if (isDependenciesSucceeded) {
                task.setDependenciesSucceeded();
            }
            if (task.doPostExecute()) {
                return CompletableFuture.runAsync(AsyncTaskExecutor.wrap(task::postExecute), task.getExecutor()).thenApply(unused -> dependenciesException);
            }
            return CompletableFuture.completedFuture(dependenciesException);
        })).thenApplyAsync(dependenciesException -> {
            boolean isDependenciesSucceeded;
            boolean bl = isDependenciesSucceeded = dependenciesException == null;
            if (!isDependenciesSucceeded && task.isRelyingOnDependencies()) {
                Logging.LOG.severe("Subtasks failed for " + task.getName());
                task.setException((Exception)dependenciesException);
                AsyncTaskExecutor.rethrow(dependenciesException);
            }
            this.checkCancellation();
            if (task.getSignificance().shouldLog()) {
                Logging.LOG.log(Level.FINER, "Task finished: " + task.getName());
            }
            task.onDone().fireEvent(new TaskEvent(this, task, false));
            this.taskListeners.forEach(it -> it.onFinished(task));
            task.setState(Task.TaskState.SUCCEEDED);
            return task.getResult();
        })).exceptionally(throwable -> {
            Throwable resolved = AsyncTaskExecutor.resolveException(throwable);
            if (resolved instanceof Exception) {
                Exception e = (Exception)resolved;
                if (e instanceof InterruptedException || e instanceof CancellationException) {
                    task.setException(null);
                    if (task.getSignificance().shouldLog()) {
                        Logging.LOG.log(Level.FINE, "Task aborted: " + task.getName());
                    }
                    task.onDone().fireEvent(new TaskEvent(this, task, true));
                    this.taskListeners.forEach(it -> it.onFailed(task, e));
                } else {
                    task.setException(e);
                    this.exception = e;
                    if (task.getSignificance().shouldLog()) {
                        Logging.LOG.log(Level.FINE, "Task failed: " + task.getName(), e);
                    }
                    task.onDone().fireEvent(new TaskEvent(this, task, true));
                    this.taskListeners.forEach(it -> it.onFailed(task, e));
                }
                task.setState(Task.TaskState.FAILED);
            }
            throw new CompletionException(resolved);
        });
    }

    private <T> CompletableFuture<T> executeTask(Task<?> parentTask, Task<T> task) {
        if (task instanceof CompletableFutureTask) {
            return this.executeCompletableFutureTask(parentTask, (CompletableFutureTask)task);
        }
        return this.executeNormalTask(parentTask, task);
    }

    private static Throwable resolveException(Throwable e) {
        if (e instanceof ExecutionException || e instanceof CompletionException) {
            return AsyncTaskExecutor.resolveException(e.getCause());
        }
        return e;
    }

    private static void rethrow(Throwable e) {
        if (e == null) {
            return;
        }
        if (!(e instanceof ExecutionException) && !(e instanceof CompletionException)) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompletionException(e);
        }
        AsyncTaskExecutor.rethrow(e.getCause());
    }

    private static Runnable wrap(ExceptionalRunnable<?> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                AsyncTaskExecutor.rethrow(e);
            }
        };
    }

    private void checkCancellation() {
        if (this.isCancelled()) {
            throw new CancellationException("Cancelled by user");
        }
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        AsyncTaskExecutor.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }
}

