/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskCompletableFuture;
import org.jackhuang.hmcl.util.function.ExceptionalBiConsumer;
import org.jackhuang.hmcl.util.function.ExceptionalConsumer;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.function.ExceptionalRunnable;

public abstract class CompletableFutureTask<T>
extends Task<T> {
    @Override
    public void execute() throws Exception {
    }

    public abstract CompletableFuture<T> getFuture(TaskCompletableFuture var1);

    protected static Runnable wrap(ExceptionalRunnable<?> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                CompletableFutureTask.rethrow(e);
            }
        };
    }

    protected static <T, R> Function<T, R> wrap(ExceptionalFunction<T, R, ?> fn) {
        return t -> {
            try {
                return fn.apply(t);
            }
            catch (Exception e) {
                CompletableFutureTask.rethrow(e);
                throw new InternalError("Unreachable code");
            }
        };
    }

    protected static <T> Consumer<T> wrap(ExceptionalConsumer<T, ?> fn) {
        return t -> {
            try {
                fn.accept(t);
            }
            catch (Exception e) {
                CompletableFutureTask.rethrow(e);
            }
        };
    }

    protected static <T, E> BiConsumer<T, E> wrap(ExceptionalBiConsumer<T, E, ?> fn) {
        return (t, e) -> {
            try {
                fn.accept(t, e);
            }
            catch (Exception ex) {
                CompletableFutureTask.rethrow(ex);
            }
        };
    }

    protected static void rethrow(Throwable e) {
        if (e == null) {
            return;
        }
        if (!(e instanceof ExecutionException) && !(e instanceof CompletionException)) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompletionException(e);
        }
        CompletableFutureTask.rethrow(e.getCause());
    }

    protected static Throwable resolveException(Throwable e) {
        if (e instanceof ExecutionException || e instanceof CompletionException) {
            return CompletableFutureTask.resolveException(e.getCause());
        }
        return e;
    }

    protected static CompletableFuture<Void> breakable(CompletableFuture<?> future) {
        return ((CompletableFuture)future.thenApplyAsync((T unused1) -> null)).exceptionally(throwable -> {
            if (CompletableFutureTask.resolveException(throwable) instanceof CustomException) {
                return null;
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    public static class CustomException
    extends RuntimeException {
    }
}

