/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public class FileDownloadTask
extends FetchTask<Void> {
    private final File file;
    private final IntegrityCheck integrityCheck;
    private Path candidate;
    private RandomAccessFile rFile;
    private InputStream stream;
    private final ArrayList<IntegrityCheckHandler> integrityCheckHandlers = new ArrayList();
    public static final IntegrityCheckHandler ZIP_INTEGRITY_CHECK_HANDLER = (filePath, destinationPath) -> {
        String ext = FileUtils.getExtension(destinationPath).toLowerCase();
        if (ext.equals("zip") || ext.equals("jar")) {
            FileSystem ignored = CompressingUtils.createReadOnlyZipFileSystem(filePath);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    };

    public FileDownloadTask(URL url, File file) {
        this(url, file, null);
    }

    public FileDownloadTask(URL url, File file, IntegrityCheck integrityCheck) {
        this(Collections.singletonList(url), file, integrityCheck);
    }

    public FileDownloadTask(URL url, File file, IntegrityCheck integrityCheck, int retry) {
        this(Collections.singletonList(url), file, integrityCheck, retry);
    }

    public FileDownloadTask(List<URL> urls, File file) {
        this(urls, file, null);
    }

    public FileDownloadTask(List<URL> urls, File file, IntegrityCheck integrityCheck) {
        this(urls, file, integrityCheck, 3);
    }

    public FileDownloadTask(List<URL> urls, File file, IntegrityCheck integrityCheck, int retry) {
        super(urls, retry);
        this.file = file;
        this.integrityCheck = integrityCheck;
        this.setName(file.getName());
    }

    public File getFile() {
        return this.file;
    }

    public FileDownloadTask setCandidate(Path candidate) {
        this.candidate = candidate;
        return this;
    }

    public void addIntegrityCheckHandler(IntegrityCheckHandler handler) {
        this.integrityCheckHandlers.add(Objects.requireNonNull(handler));
    }

    @Override
    protected FetchTask.EnumCheckETag shouldCheckETag() {
        if (this.integrityCheck != null && this.caching) {
            Optional<Path> cache = this.repository.checkExistentFile(this.candidate, this.integrityCheck.getAlgorithm(), this.integrityCheck.getChecksum());
            if (cache.isPresent()) {
                try {
                    FileUtils.copyFile(cache.get().toFile(), this.file);
                    Logging.LOG.log(Level.FINER, "Successfully verified file " + this.file + " from " + this.urls.get(0));
                    return FetchTask.EnumCheckETag.CACHED;
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to copy cache files", e);
                }
            }
            return FetchTask.EnumCheckETag.NOT_CHECK_E_TAG;
        }
        return FetchTask.EnumCheckETag.CHECK_E_TAG;
    }

    @Override
    protected void beforeDownload(URL url) {
        Logging.LOG.log(Level.FINER, "Downloading " + url + " to " + this.file);
    }

    @Override
    protected void useCachedResult(Path cache) throws IOException {
        FileUtils.copyFile(cache.toFile(), this.file);
    }

    @Override
    protected FetchTask.Context getContext(final URLConnection conn, final boolean checkETag) throws IOException {
        final Path temp = Files.createTempFile(null, null, new FileAttribute[0]);
        final RandomAccessFile rFile = new RandomAccessFile(temp.toFile(), "rw");
        final MessageDigest digest = this.integrityCheck == null ? null : this.integrityCheck.createDigest();
        return new FetchTask.Context(){

            @Override
            public void write(byte[] buffer, int offset, int len) throws IOException {
                if (digest != null) {
                    digest.update(buffer, offset, len);
                }
                rFile.write(buffer, offset, len);
            }

            @Override
            public void close() throws IOException {
                try {
                    rFile.close();
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to close file: " + rFile, e);
                }
                if (!this.isSuccess()) {
                    try {
                        Files.delete(temp);
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to delete file: " + rFile, e);
                    }
                    return;
                }
                for (IntegrityCheckHandler handler : FileDownloadTask.this.integrityCheckHandlers) {
                    handler.checkIntegrity(temp, FileDownloadTask.this.file.toPath());
                }
                Files.deleteIfExists(FileDownloadTask.this.file.toPath());
                if (!FileUtils.makeDirectory(FileDownloadTask.this.file.getAbsoluteFile().getParentFile())) {
                    throw new IOException("Unable to make parent directory " + FileDownloadTask.this.file);
                }
                try {
                    FileUtils.moveFile(temp.toFile(), FileDownloadTask.this.file);
                }
                catch (Exception e) {
                    throw new IOException("Unable to move temp file from " + temp + " to " + FileDownloadTask.this.file, e);
                }
                if (FileDownloadTask.this.integrityCheck != null) {
                    FileDownloadTask.this.integrityCheck.performCheck(digest);
                }
                if (FileDownloadTask.this.caching && FileDownloadTask.this.integrityCheck != null) {
                    try {
                        FileDownloadTask.this.repository.cacheFile(FileDownloadTask.this.file.toPath(), FileDownloadTask.this.integrityCheck.getAlgorithm(), FileDownloadTask.this.integrityCheck.getChecksum());
                    }
                    catch (IOException e) {
                        Logging.LOG.log(Level.WARNING, "Failed to cache file", e);
                    }
                }
                if (checkETag) {
                    FileDownloadTask.this.repository.cacheRemoteFile(FileDownloadTask.this.file.toPath(), conn);
                }
            }
        };
    }

    public static class IntegrityCheck {
        private String algorithm;
        private String checksum;

        public IntegrityCheck(String algorithm, String checksum) {
            this.algorithm = Objects.requireNonNull(algorithm);
            this.checksum = Objects.requireNonNull(checksum);
        }

        public static IntegrityCheck of(String algorithm, String checksum) {
            if (checksum == null) {
                return null;
            }
            return new IntegrityCheck(algorithm, checksum);
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public MessageDigest createDigest() {
            return DigestUtils.getDigest(this.algorithm);
        }

        public void performCheck(MessageDigest digest) throws ChecksumMismatchException {
            String actualChecksum = String.format("%1$040x", new BigInteger(1, digest.digest()));
            if (!this.checksum.equalsIgnoreCase(actualChecksum)) {
                throw new ChecksumMismatchException(this.algorithm, this.checksum, actualChecksum);
            }
        }
    }

    public static interface IntegrityCheckHandler {
        public void checkIntegrity(Path var1, Path var2) throws IOException;
    }
}

