/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.effects.JFXDepthManager;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.util.i18n.I18n;

public class InstallerItem
extends Control {
    private final String id;
    private final String imageUrl;
    public final StringProperty libraryVersion = new SimpleStringProperty();
    public final StringProperty incompatibleLibraryName = new SimpleStringProperty();
    public final BooleanProperty incompatibleWithGame = new SimpleBooleanProperty();
    public final BooleanProperty removable = new SimpleBooleanProperty();
    public final BooleanProperty upgradable = new SimpleBooleanProperty(false);
    public final BooleanProperty installable = new SimpleBooleanProperty(true);
    public final ObjectProperty<EventHandler<? super MouseEvent>> removeAction = new SimpleObjectProperty();
    public final ObjectProperty<EventHandler<? super MouseEvent>> action = new SimpleObjectProperty();

    public InstallerItem(LibraryAnalyzer.LibraryType id) {
        this(id.getPatchId());
    }

    public InstallerItem(String id) {
        this.id = id;
        switch (id) {
            case "game": {
                this.imageUrl = "/assets/img/grass.png";
                break;
            }
            case "fabric": {
                this.imageUrl = "/assets/img/fabric.png";
                break;
            }
            case "forge": {
                this.imageUrl = "/assets/img/forge.png";
                break;
            }
            case "liteloader": {
                this.imageUrl = "/assets/img/chicken.png";
                break;
            }
            case "optifine": {
                this.imageUrl = "/assets/img/command.png";
                break;
            }
            default: {
                this.imageUrl = null;
            }
        }
    }

    public void setState(String libraryVersion, boolean incompatibleWithGame, boolean removable) {
        this.libraryVersion.set((Object)libraryVersion);
        this.incompatibleWithGame.set(incompatibleWithGame);
        this.removable.set(removable);
    }

    public String getLibraryId() {
        return this.id;
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallerItemSkin(this);
    }

    public static class InstallerItemGroup {
        public InstallerItem game = new InstallerItem(LibraryAnalyzer.LibraryType.MINECRAFT);
        public InstallerItem fabric = new InstallerItem(LibraryAnalyzer.LibraryType.FABRIC);
        public InstallerItem forge = new InstallerItem(LibraryAnalyzer.LibraryType.FORGE);
        public InstallerItem liteLoader = new InstallerItem(LibraryAnalyzer.LibraryType.LITELOADER);
        public InstallerItem optiFine = new InstallerItem(LibraryAnalyzer.LibraryType.OPTIFINE);

        public InstallerItemGroup() {
            this.forge.incompatibleLibraryName.bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.fabric.libraryVersion.get() != null) {
                    return LibraryAnalyzer.LibraryType.FABRIC.getPatchId();
                }
                return null;
            }, (Observable[])new Observable[]{this.fabric.libraryVersion}));
            this.liteLoader.incompatibleLibraryName.bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.fabric.libraryVersion.get() != null) {
                    return LibraryAnalyzer.LibraryType.FABRIC.getPatchId();
                }
                return null;
            }, (Observable[])new Observable[]{this.fabric.libraryVersion}));
            this.optiFine.incompatibleLibraryName.bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.fabric.libraryVersion.get() != null) {
                    return LibraryAnalyzer.LibraryType.FABRIC.getPatchId();
                }
                return null;
            }, (Observable[])new Observable[]{this.fabric.libraryVersion}));
            this.fabric.incompatibleLibraryName.bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.liteLoader.libraryVersion.get() != null) {
                    return LibraryAnalyzer.LibraryType.LITELOADER.getPatchId();
                }
                if (this.optiFine.libraryVersion.get() != null) {
                    return LibraryAnalyzer.LibraryType.OPTIFINE.getPatchId();
                }
                if (this.forge.libraryVersion.get() != null) {
                    return LibraryAnalyzer.LibraryType.FORGE.getPatchId();
                }
                return null;
            }, (Observable[])new Observable[]{this.optiFine.libraryVersion, this.forge.libraryVersion}));
        }

        public InstallerItem[] getLibraries() {
            return new InstallerItem[]{this.game, this.fabric, this.forge, this.liteLoader, this.optiFine};
        }
    }

    public static class InstallerItemSkin
    extends SkinBase<InstallerItem> {
        InstallerItemSkin(InstallerItem control) {
            super((Control)control);
            HBox hbox = new HBox();
            this.getChildren().setAll((Object[])new Node[]{hbox});
            JFXDepthManager.setDepth((Node)hbox, 1);
            hbox.getStyleClass().add((Object)"card");
            hbox.setAlignment(Pos.CENTER_LEFT);
            if (control.imageUrl != null) {
                hbox.getChildren().add((Object)FXUtils.limitingSize((Node)new ImageView(new Image(control.imageUrl, 32.0, 32.0, true, true)), 32.0, 32.0));
            }
            Label nameLabel = new Label();
            hbox.getChildren().add((Object)nameLabel);
            nameLabel.setPrefWidth(80.0);
            nameLabel.textProperty().set((Object)(I18n.hasKey("install.installer." + control.id) ? I18n.i18n("install.installer." + control.id) : control.id));
            HBox.setMargin((Node)nameLabel, (Insets)new Insets(0.0, 4.0, 0.0, 4.0));
            Label label = new Label();
            hbox.getChildren().add((Object)label);
            label.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
            label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                String incompatibleWith = (String)control.incompatibleLibraryName.get();
                String version = (String)control.libraryVersion.get();
                if (control.incompatibleWithGame.get()) {
                    return I18n.i18n("install.installer.change_version", version);
                }
                if (incompatibleWith != null) {
                    return I18n.i18n("install.installer.incompatible", I18n.i18n("install.installer." + incompatibleWith));
                }
                if (version == null) {
                    return I18n.i18n("install.installer.not_installed");
                }
                return I18n.i18n("install.installer.version", version);
            }, (Observable[])new Observable[]{control.incompatibleLibraryName, control.incompatibleWithGame, control.libraryVersion}));
            BorderPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
            BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
            JFXButton closeButton = new JFXButton();
            closeButton.setGraphic(SVG.close(Theme.blackFillBinding(), -1.0, -1.0));
            closeButton.getStyleClass().add((Object)"toggle-icon4");
            closeButton.visibleProperty().bind((ObservableValue)control.removable);
            closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
            closeButton.onMouseClickedProperty().bind(control.removeAction);
            hbox.getChildren().add((Object)closeButton);
            JFXButton arrowButton = new JFXButton();
            arrowButton.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> control.upgradable.get() ? SVG.update(Theme.blackFillBinding(), -1.0, -1.0) : SVG.arrowRight(Theme.blackFillBinding(), -1.0, -1.0), (Observable[])new Observable[]{control.upgradable}));
            arrowButton.getStyleClass().add((Object)"toggle-icon4");
            arrowButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> control.installable.get() && control.incompatibleLibraryName.get() == null, (Observable[])new Observable[]{control.installable, control.incompatibleLibraryName}));
            arrowButton.managedProperty().bind((ObservableValue)arrowButton.visibleProperty());
            arrowButton.onMouseClickedProperty().bind(control.action);
            hbox.getChildren().add((Object)arrowButton);
            FXUtils.onChangeAndOperate(arrowButton.visibleProperty(), clickable -> {
                if (clickable.booleanValue()) {
                    hbox.onMouseClickedProperty().bind(control.action);
                    hbox.setCursor(Cursor.HAND);
                } else {
                    hbox.onMouseClickedProperty().unbind();
                    hbox.onMouseClickedProperty().set(null);
                    hbox.setCursor(Cursor.DEFAULT);
                }
            });
        }
    }
}

