/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXScrollPane;
import com.jfoenix.effects.JFXDepthManager;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;

public abstract class ToolbarListPageSkin<T extends ListPageBase<? extends Node>>
extends SkinBase<T> {
    public ToolbarListPageSkin(T skinnable) {
        super(skinnable);
        SpinnerPane spinnerPane = new SpinnerPane();
        spinnerPane.getStyleClass().add((Object)"large-spinner-pane");
        BorderPane root = new BorderPane();
        List<Node> toolbarButtons = this.initializeToolbar(skinnable);
        if (!toolbarButtons.isEmpty()) {
            HBox toolbar = new HBox();
            toolbar.getStyleClass().add((Object)"jfx-tool-bar-second");
            JFXDepthManager.setDepth((Node)toolbar, 1);
            toolbar.setPickOnBounds(false);
            toolbar.getChildren().setAll(toolbarButtons);
            root.setTop((Node)toolbar);
        }
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        VBox content = new VBox();
        content.setSpacing(10.0);
        content.setPadding(new Insets(10.0));
        Bindings.bindContent((List)content.getChildren(), ((ListPageBase)((Object)skinnable)).itemsProperty());
        scrollPane.setContent((Node)content);
        JFXScrollPane.smoothScrolling(scrollPane);
        root.setCenter((Node)scrollPane);
        spinnerPane.loadingProperty().bind((ObservableValue)((ListPageBase)((Object)skinnable)).loadingProperty());
        spinnerPane.setContent((Node)root);
        this.getChildren().setAll((Object[])new Node[]{spinnerPane});
    }

    public static Node wrap(Node node) {
        StackPane stackPane = new StackPane();
        stackPane.setPadding(new Insets(0.0, 5.0, 0.0, 2.0));
        stackPane.getChildren().setAll((Object[])new Node[]{node});
        return stackPane;
    }

    public static JFXButton createToolbarButton(String text, SVG.SVGIcon creator, Runnable onClick) {
        JFXButton ret = new JFXButton();
        ret.getStyleClass().add((Object)"jfx-tool-bar-button");
        ret.textFillProperty().bind(Theme.foregroundFillBinding());
        ret.setGraphic(ToolbarListPageSkin.wrap(creator.createIcon(Theme.foregroundFillBinding(), -1.0, -1.0)));
        ret.setText(text);
        ret.setOnMouseClicked(e -> onClick.run());
        return ret;
    }

    public static JFXButton createDecoratorButton(String tooltip, SVG.SVGIcon creator, Runnable onClick) {
        JFXButton ret = new JFXButton();
        ret.getStyleClass().add((Object)"jfx-decorator-button");
        ret.textFillProperty().bind(Theme.foregroundFillBinding());
        ret.setGraphic(ToolbarListPageSkin.wrap(creator.createIcon(Theme.foregroundFillBinding(), -1.0, -1.0)));
        FXUtils.installFastTooltip((Node)ret, tooltip);
        ret.setOnMouseClicked(e -> onClick.run());
        return ret;
    }

    protected abstract List<Node> initializeToolbar(T var1);
}

