/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.util.i18n.I18n;

public class UpgradeDialog
extends JFXDialogLayout {
    private final WebView webView = new WebView();

    public UpgradeDialog(Runnable updateRunnable) {
        this.setHeading(new Node[]{new Label(I18n.i18n("update.changelog"))});
        WebView webView = new WebView();
        WebEngine engine = webView.getEngine();
        engine.load("https://hmcl.huangyuhui.net/changelog/" + ConfigHolder.config().getUpdateChannel().channelName);
        engine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            String url = engine.getLoadWorker().getMessage().trim();
            if (!url.startsWith("https://hmcl.huangyuhui.net/changelog/")) {
                engine.getLoadWorker().cancel();
                FXUtils.openLink(url);
            }
        });
        this.setBody(new Node[]{webView});
        JFXButton updateButton = new JFXButton(I18n.i18n("update.accept"));
        updateButton.getStyleClass().add((Object)"dialog-accept");
        updateButton.setOnMouseClicked(e -> updateRunnable.run());
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        cancelButton.setOnMouseClicked(e -> this.fireEvent(new DialogCloseEvent()));
        this.setActions(new Node[]{updateButton, cancelButton});
    }
}

